"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialGlobalUrlParam = exports.globalUrlParamReducer = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialGlobalUrlParam = exports.initialGlobalUrlParam = {};
const globalUrlParamReducer = exports.globalUrlParamReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialGlobalUrlParam).case(_actions.registerUrlParam, (state, {
  key,
  initialValue
}) => {
  // It doesn't allow the query param to be used twice
  if (state[key] !== undefined) {
    // eslint-disable-next-line no-console
    console.error(`Url param key '${key}' is already being used.`);
    return state;
  }
  return {
    ...state,
    [key]: initialValue
  };
}).case(_actions.deregisterUrlParam, (state, {
  key
}) => {
  const nextState = {
    ...state
  };
  delete nextState[key];
  return nextState;
}).case(_actions.updateUrlParam, (state, {
  key,
  value
}) => {
  if (state[key] === undefined || (0, _fastDeepEqual.default)(state[key], value)) {
    return state;
  }
  return {
    ...state,
    [key]: value
  };
}).build();