"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withAvailablePackages = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _with_lazy_hook = require("../../../components/with_lazy_hook");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/integrations/components/with_available_packages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * HOC to wrap a component with the `availablePackages` from Fleet.
 */
const withAvailablePackages = Component => {
  return (0, _with_lazy_hook.withLazyHook)(/*#__PURE__*/_react.default.memo(function WithAvailablePackages({
    useAvailablePackages,
    prereleaseIntegrationsEnabled = false,
    ...props
  }) {
    const availablePackages = useAvailablePackages({
      prereleaseIntegrationsEnabled
    });
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      availablePackages,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 16
      }
    }));
  }), () => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.AvailablePackagesHook()), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "loadingPackages",
    isLoading: true,
    lines: _constants.LOADING_SKELETON_TEXT_LINES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }));
};
exports.withAvailablePackages = withAvailablePackages;