"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasGraphVisualizationLicense = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _use_license = require("./use_license");
var _use_product_feature_keys = require("./use_product_feature_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to determine if the user has the required license for graph visualization feature.
 *
 * In ESS/Self-Managed: Requires Platinum license or higher
 * In Serverless: Requires Security Analytics Complete tier (not Essentials)
 *
 * @returns boolean indicating if graph visualization is available
 */
const useHasGraphVisualizationLicense = () => {
  const productFeatureKeys = (0, _use_product_feature_keys.useProductFeatureKeys)();
  const licenseService = (0, _use_license.useLicense)();
  return productFeatureKeys.has(_keys.ProductFeatureSecurityKey.graphVisualization) && licenseService.isPlatinumPlus();
};
exports.useHasGraphVisualizationLicense = useHasGraphVisualizationLicense;