"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasEntityHighlightsLicense = void 0;
var _use_license = require("./use_license");
var _helper_hooks = require("../../helper_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to determine if the user has the required license for entity highlights (GenAI) feature.
 *
 * In ESS/Self-Managed: Requires Enterprise license or higher
 * In Serverless: Requires Security Analytics Complete tier (not Essentials)
 */
const useHasEntityHighlightsLicense = () => {
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const licenseService = (0, _use_license.useLicense)();
  return hasEntityAnalyticsCapability && licenseService.isEnterprise();
};
exports.useHasEntityHighlightsLicense = useHasEntityHighlightsLicense;