"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractValidationResults = extractValidationResults;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractValidationResults(formFields, warningValidationCodes) {
  const warningValidationCodesSet = new Set(warningValidationCodes);
  const errors = [];
  const warnings = [];
  for (const field of formFields) {
    for (const error of field.errors) {
      var _error$path;
      const path = (_error$path = error.path) !== null && _error$path !== void 0 ? _error$path : field.path;
      if (!error.code || !warningValidationCodesSet.has(error.code)) {
        errors.push({
          ...error,
          path
        });
      } else {
        warnings.push({
          ...error,
          path
        });
      }
    }
  }
  return {
    errors,
    warnings
  };
}