"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitTimerangeFromUrlParam = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _use_experimental_features = require("../use_experimental_features");
var _normalize_time_range = require("../../utils/normalize_time_range");
var _inputs = require("../../store/inputs");
var _super_date_picker = require("../../components/super_date_picker");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../use_url_state");
var _constants = require("../../store/inputs/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInitTimerangeFromUrlParam = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isSocTrendsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('socTrendsEnabled');
  const onInitialize = (0, _react.useCallback)(initialState => initializeTimerangeFromUrlParam(initialState, dispatch, isSocTrendsEnabled), [dispatch, isSocTrendsEnabled]);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.timerange, onInitialize);
};
exports.useInitTimerangeFromUrlParam = useInitTimerangeFromUrlParam;
const initializeTimerangeFromUrlParam = (initialState, dispatch, isSocTrendsEnabled) => {
  if (initialState != null) {
    const globalLinkTo = {
      linkTo: (0, _fp.get)('global.linkTo', initialState)
    };
    const globalTimerangeKind = (0, _fp.get)('global.timerange.kind', initialState);
    const timelineLinkTo = {
      linkTo: (0, _fp.get)('timeline.linkTo', initialState)
    };
    const timelineTimerangeKind = (0, _fp.get)('timeline.timerange.kind', initialState);
    const socTrendsLinkTo = {
      linkTo: (0, _fp.get)('socTrends.linkTo', initialState)
    };
    const socTrendsType = (0, _fp.get)('socTrends.timerange.kind', initialState);
    const valueReportType = (0, _fp.get)('valueReport.timerange.kind', initialState);
    if (isSocTrendsEnabled) {
      if ((0, _fp.isEmpty)(socTrendsLinkTo.linkTo)) {
        dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.socTrends]));
      } else {
        dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.socTrends]));
      }
    }
    if ((0, _fp.isEmpty)(globalLinkTo.linkTo)) {
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
      if (isSocTrendsEnabled) {
        dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.socTrends]));
      }
    } else {
      dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
      if (isSocTrendsEnabled) {
        dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.socTrends]));
      }
    }
    if ((0, _fp.isEmpty)(timelineLinkTo.linkTo)) {
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
    } else {
      dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
    }
    if (timelineTimerangeKind) {
      if (timelineTimerangeKind === 'absolute') {
        const absoluteRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('timeline.timerange', initialState));
        dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
          ...absoluteRange,
          id: _constants.InputsModelId.timeline
        }));
      }
      if (timelineTimerangeKind === 'relative') {
        const relativeRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('timeline.timerange', initialState));

        // Updates date values when timerange is relative
        relativeRange.from = (0, _super_date_picker.formatDate)(relativeRange.fromStr);
        relativeRange.to = (0, _super_date_picker.formatDate)(relativeRange.toStr, {
          roundUp: true
        });
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...relativeRange,
          id: _constants.InputsModelId.timeline
        }));
      }
    }
    if (globalTimerangeKind) {
      if (globalTimerangeKind === 'absolute') {
        const absoluteRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('global.timerange', initialState));
        dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
          ...absoluteRange,
          id: _constants.InputsModelId.global
        }));
      }
      if (globalTimerangeKind === 'relative') {
        const relativeRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('global.timerange', initialState));

        // Updates date values when timerange is relative
        relativeRange.from = (0, _super_date_picker.formatDate)(relativeRange.fromStr);
        relativeRange.to = (0, _super_date_picker.formatDate)(relativeRange.toStr, {
          roundUp: true
        });
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...relativeRange,
          id: _constants.InputsModelId.global
        }));
      }
    }
    if (isSocTrendsEnabled && socTrendsType) {
      if (socTrendsType === 'absolute') {
        const absoluteRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('socTrends.timerange', initialState));
        dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
          ...absoluteRange,
          id: _constants.InputsModelId.socTrends
        }));
      }
      if (socTrendsType === 'relative') {
        const relativeRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('socTrends.timerange', initialState));

        // Updates date values when timerange is relative
        relativeRange.from = (0, _super_date_picker.formatDate)(relativeRange.fromStr);
        relativeRange.to = (0, _super_date_picker.formatDate)(relativeRange.toStr, {
          roundUp: true
        });
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...relativeRange,
          id: _constants.InputsModelId.socTrends
        }));
      }
    }
    if (valueReportType) {
      if (valueReportType === 'absolute') {
        const absoluteRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('valueReport.timerange', initialState));
        dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
          ...absoluteRange,
          id: _constants.InputsModelId.valueReport
        }));
      }
      if (valueReportType === 'relative') {
        const relativeRange = (0, _normalize_time_range.normalizeTimeRange)((0, _fp.get)('valueReport.timerange', initialState));

        // Updates date values when timerange is relative
        relativeRange.from = (0, _super_date_picker.formatDate)(relativeRange.fromStr);
        relativeRange.to = (0, _super_date_picker.formatDate)(relativeRange.toStr, {
          roundUp: true
        });
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          ...relativeRange,
          id: _constants.InputsModelId.valueReport
        }));
      }
    }
  }
};