"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchStrategy = exports.useSearch = void 0;
var _rxjs = require("rxjs");
var _fp = require("lodash/fp");
var _react = require("react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../helpers");
var _kibana = require("../../lib/kibana");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _use_track_http_request = require("../../lib/apm/use_track_http_request");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_INSPECT = {
  dsl: [],
  response: []
};
const useSearch = factoryQueryType => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    startTracking
  } = (0, _use_track_http_request.useTrackHttpRequest)();
  const search = (0, _react.useCallback)(({
    abortSignal,
    request
  }) => {
    const {
      endTracking
    } = startTracking({
      name: `${_constants.APP_UI_ID} searchStrategy ${factoryQueryType}`,
      spanName: 'batched search'
    });
    // return observable directly, any extra subscription causes duplicate requests
    return data.search.search({
      ...request,
      factoryQueryType
    }, {
      strategy: 'securitySolutionSearchStrategy',
      abortSignal
    }).pipe((0, _rxjs.filter)(response => !(0, _public.isRunningResponse)(response)), (0, _rxjs.catchError)(error => {
      endTracking(abortSignal.aborted ? 'aborted' : 'error');
      throw error;
    }), (0, _rxjs.tap)(() => {
      endTracking('success');
    }));
  }, [data.search, factoryQueryType, startTracking]);
  return search;
};
exports.useSearch = useSearch;
const useSearchStrategy = ({
  factoryQueryType,
  initialResult,
  errorMessage,
  abort = false,
  showErrorToast = true
}) => {
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const refetch = (0, _react.useRef)(_fp.noop);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const search = useSearch(factoryQueryType);
  const {
    start,
    error,
    result,
    loading
  } = (0, _securitysolutionHookUtils.useObservable)(search);
  (0, _react.useEffect)(() => {
    if (showErrorToast && error != null && !(error instanceof _common.AbortError)) {
      addError(error, {
        title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : i18n.DEFAULT_ERROR_SEARCH_STRATEGY(factoryQueryType)
      });
    }
  }, [addError, error, errorMessage, factoryQueryType, showErrorToast]);
  const searchCb = (0, _react.useCallback)(request => {
    const startSearch = () => {
      abortCtrl.current = new AbortController();
      start({
        request,
        abortSignal: abortCtrl.current.signal
      });
    };
    abortCtrl.current.abort();
    startSearch();
    refetch.current = startSearch;
  }, [start]);
  (0, _react.useEffect)(() => {
    return () => {
      abortCtrl.current.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (abort) {
      abortCtrl.current.abort();
    }
  }, [abort]);
  const [formattedResult, inspect] = (0, _react.useMemo)(() => {
    if (!result) {
      return [initialResult, EMPTY_INSPECT];
    }
    return [(0, _fp.omit)('rawResponse', result), (0, _helpers.getInspectResponse)(result, EMPTY_INSPECT)];
  }, [result, initialResult]);
  return {
    loading,
    result: formattedResult,
    error,
    search: searchCb,
    refetch: refetch.current,
    inspect
  };
};
exports.useSearchStrategy = useSearchStrategy;