"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationEmbeddable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _chart_label = require("../../../overview/components/detection_response/alerts_by_status/chart_label");
var _use_selector = require("../../hooks/use_selector");
var _inputs = require("../../store/inputs");
var _donutchart = require("../charts/donutchart");
var _constants = require("../../store/inputs/constants");
var _use_refetch_by_session = require("../page/use_refetch_by_session");
var _lens_embeddable = require("./lens_embeddable");
var _containers = require("../../../sourcerer/containers");
var _use_visualization_response = require("./use_visualization_response");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/visualization_actions/visualization_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VisualizationEmbeddableComponent = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    inputId = _constants.InputsModelId.global,
    id,
    isDonut,
    label,
    donutTextWrapperClassName,
    donutTitleLabel,
    onLoad,
    signalIndexName,
    ...lensProps
  } = props;
  const {
    session,
    refetchByRestartingSession,
    refetchByDeletingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId,
    queryId: id
  });
  const {
    indicesExist: oldIndicesExist
  } = (0, _containers.useSourcererDataView)(lensProps.scopeId);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView
  } = (0, _use_data_view.useDataView)(lensProps.scopeId);
  const indicesExist = newDataViewPickerEnabled ? dataView.hasMatchedIndices() : oldIndicesExist;
  const memorizedTimerange = (0, _react.useRef)(lensProps.timerange);
  const getGlobalQuery = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQueryByIdSelector(), []);
  const {
    searchSessionId
  } = (0, _use_selector.useDeepEqualSelector)(state => getGlobalQuery(state, id));
  const {
    tables: visualizationTables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: id
  });
  const visualizationTablesTotalCount = visualizationTables && visualizationTables.meta.statistics.totalCount;
  const dataExists = visualizationTablesTotalCount != null && visualizationTablesTotalCount > 0;
  const donutTextWrapperStyles = dataExists ? (0, _react2.css)`
        top: 40%;
        right: 12%;
      ` : (0, _react2.css)`
        top: 66%;
        right: 12%;
      `;
  const onEmbeddableLoad = (0, _react.useCallback)(({
    requests,
    responses,
    isLoading,
    tables
  }) => {
    dispatch(_inputs.inputsActions.setQuery({
      inputId,
      id,
      searchSessionId: session.current.start(),
      refetch: refetchByRestartingSession,
      loading: isLoading,
      inspect: isLoading ? null : {
        dsl: requests,
        response: responses
      },
      tables
    }));
    if (typeof onLoad === 'function') {
      onLoad({
        requests,
        responses,
        isLoading,
        tables
      });
    }
  }, [dispatch, inputId, id, session, refetchByRestartingSession, onLoad]);
  (0, _react.useEffect)(() => {
    var _memorizedTimerange$c, _memorizedTimerange$c2;
    // This handles timerange update when (alert) indices not found
    if (!indicesExist && ((_memorizedTimerange$c = memorizedTimerange.current) === null || _memorizedTimerange$c === void 0 ? void 0 : _memorizedTimerange$c.from) !== lensProps.timerange.from || ((_memorizedTimerange$c2 = memorizedTimerange.current) === null || _memorizedTimerange$c2 === void 0 ? void 0 : _memorizedTimerange$c2.to) !== lensProps.timerange.to) {
      memorizedTimerange.current = lensProps.timerange;
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    }
  }, [dispatch, id, indicesExist, inputId, lensProps.timerange]);
  (0, _react.useEffect)(() => {
    // This handles initial mount and refetch when (alert) indices not found
    if (!searchSessionId) {
      dispatch(_inputs.inputsActions.setQuery({
        inputId,
        id,
        searchSessionId: session.current.start(),
        refetch: dataExists ? refetchByRestartingSession : refetchByDeletingSession,
        loading: false,
        inspect: null
      }));
    }
  }, [dispatch, inputId, id, session, dataExists, refetchByRestartingSession, searchSessionId, refetchByDeletingSession]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch(_inputs.inputsActions.deleteOneQuery({
        inputId,
        id
      }));
    };
  }, [dispatch, id, inputId]);
  if (!lensProps.getLensAttributes && !lensProps.lensAttributes || !lensProps.timerange) {
    return null;
  }
  if (isDonut) {
    return /*#__PURE__*/_react.default.createElement(_donutchart.DonutChartWrapper, {
      isChartEmbeddablesEnabled: true,
      dataExists: dataExists,
      label: label,
      title: visualizationTablesTotalCount != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, donutTitleLabel && /*#__PURE__*/_react.default.createElement("span", {
        className: "donutTitleLabel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 35
        }
      }, donutTitleLabel), /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
        count: visualizationTablesTotalCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 15
        }
      })) : null,
      donutTextWrapperClassName: donutTextWrapperClassName,
      donutTextWrapperStyles: donutTextWrapperStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_lens_embeddable.LensEmbeddable, (0, _extends2.default)({}, lensProps, {
      signalIndexName: signalIndexName,
      id: id,
      onLoad: onEmbeddableLoad,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_lens_embeddable.LensEmbeddable, (0, _extends2.default)({}, lensProps, {
    signalIndexName: signalIndexName,
    id: id,
    onLoad: onEmbeddableLoad,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }));
};
const VisualizationEmbeddable = exports.VisualizationEmbeddable = /*#__PURE__*/_react.default.memo(VisualizationEmbeddableComponent);