"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkAlertTagsPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _reducer = require("./reducer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/alert_bulk_tags.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BulkAlertTagsPanelComponent = ({
  alertItems,
  refresh,
  refetchQuery,
  setIsLoading,
  clearSelection,
  closePopoverMenu,
  onSubmit
}) => {
  const [defaultAlertTagOptions] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_ALERT_TAGS_KEY);
  const existingTags = (0, _react.useMemo)(() => alertItems.map(item => {
    var _item$data$find$value, _item$data$find;
    return (_item$data$find$value = (_item$data$find = item.data.find(data => data.field === _ruleDataUtils.ALERT_WORKFLOW_TAGS)) === null || _item$data$find === void 0 ? void 0 : _item$data$find.value) !== null && _item$data$find$value !== void 0 ? _item$data$find$value : [];
  }), [alertItems]);
  const [{
    selectableAlertTags,
    tagsToAdd,
    tagsToRemove
  }, dispatch] = (0, _react.useReducer)((0, _reducer.createAlertTagsReducer)(), _reducer.initialState);
  const addAlertTag = (0, _react.useCallback)(value => {
    dispatch({
      type: 'addAlertTag',
      value
    });
  }, [dispatch]);
  const removeAlertTag = (0, _react.useCallback)(value => {
    dispatch({
      type: 'removeAlertTag',
      value
    });
  }, [dispatch]);
  const setSelectableAlertTags = (0, _react.useCallback)(value => {
    dispatch({
      type: 'setSelectableAlertTags',
      value
    });
  }, [dispatch]);
  const onTagsUpdate = (0, _react.useCallback)(async () => {
    if (tagsToAdd.size === 0 && tagsToRemove.size === 0) {
      closePopoverMenu();
      return;
    }
    const tagsToAddArray = Array.from(tagsToAdd);
    const tagsToRemoveArray = Array.from(tagsToRemove);
    const ids = alertItems.map(item => item._id);
    const tags = {
      tags_to_add: tagsToAddArray,
      tags_to_remove: tagsToRemoveArray
    };
    const onSuccess = () => {
      if (refetchQuery) refetchQuery();
      if (refresh) refresh();
      if (clearSelection) clearSelection();
    };
    if (onSubmit != null) {
      closePopoverMenu();
      await onSubmit(tags, ids, onSuccess, setIsLoading);
    }
  }, [closePopoverMenu, tagsToAdd, tagsToRemove, alertItems, refetchQuery, refresh, clearSelection, setIsLoading, onSubmit]);
  const handleTagsOnChange = (0, _react.useCallback)((newOptions, event, changedOption) => {
    if (changedOption.checked === 'on') {
      addAlertTag(changedOption.label);
    } else if (!changedOption.checked) {
      removeAlertTag(changedOption.label);
    }
    setSelectableAlertTags(newOptions);
  }, [addAlertTag, removeAlertTag, setSelectableAlertTags]);
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'setSelectableAlertTags',
      value: (0, _helpers.createInitialTagsState)(existingTags, defaultAlertTagOptions)
    });
  }, [existingTags, defaultAlertTagOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: i18n.ALERT_TAGS_MENU_SEARCH_PLACEHOLDER
    },
    "aria-label": i18n.ALERT_TAGS_MENU_SEARCH_PLACEHOLDER,
    options: selectableAlertTags,
    onChange: handleTagsOnChange,
    emptyMessage: i18n.ALERT_TAGS_MENU_EMPTY,
    noMatchesMessage: i18n.ALERT_TAGS_MENU_SEARCH_NO_TAGS_FOUND,
    "data-test-subj": "alert-tags-selectable-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, search), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alert-tags-update-button",
    fullWidth: true,
    size: "s",
    onClick: onTagsUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, i18n.ALERT_TAGS_APPLY_BUTTON_MESSAGE));
};
const BulkAlertTagsPanel = exports.BulkAlertTagsPanel = /*#__PURE__*/(0, _react.memo)(BulkAlertTagsPanelComponent);