"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOAD_CONNECTORS_ERROR_MESSAGE = exports.ENDPOINT_COMMANDS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOAD_CONNECTORS_ERROR_MESSAGE = exports.LOAD_CONNECTORS_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.connectors.useLoadConnectors.errorMessage', {
  defaultMessage: 'Error loading connectors. Please check your configuration and try again.'
});
const ENDPOINT_COMMANDS = exports.ENDPOINT_COMMANDS = Object.freeze({
  tried: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.tried', {
    values: {
      command
    },
    defaultMessage: 'tried to execute {command} command'
  }),
  executed: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.executed', {
    values: {
      command
    },
    defaultMessage: 'executed {command} command'
  }),
  pending: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.pending', {
    values: {
      command
    },
    defaultMessage: 'is executing {command} command'
  }),
  failed: command => _i18n.i18n.translate('xpack.securitySolution.eventDetails.responseActions.endpoint.failed', {
    values: {
      command
    },
    defaultMessage: 'failed to execute {command} command'
  })
});