"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbsNav = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _types = require("../../../../app/types");
var _store = require("../../../../timelines/store");
var _timeline = require("../../../../../common/types/timeline");
var _link_to = require("../../link_to");
var _telemetry = require("../../../lib/telemetry");
var _kibana = require("../../../lib/kibana");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _breadcrumbs = require("../../../breadcrumbs");
var _constants = require("../../../../../common/constants");
var _trailing_breadcrumbs = require("./trailing_breadcrumbs");
var _links_hooks = require("../../../links/links_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbsNav = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const [routeProps] = (0, _use_route_spy.useRouteSpy)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const parentLinks = (0, _links_hooks.useParentLinks)(routeProps.pageName);
  (0, _react.useEffect)(() => {
    // cases manages its own breadcrumbs
    if (!routeProps.pageName || routeProps.pageName === _types.SecurityPageName.case) {
      return;
    }
    const leadingBreadcrumbs = getLeadingBreadcrumbs(parentLinks, getSecuritySolutionUrl);
    const trailingBreadcrumbs = (0, _trailing_breadcrumbs.getTrailingBreadcrumbs)(routeProps, getSecuritySolutionUrl);
    (0, _breadcrumbs.updateBreadcrumbsNav)({
      leading: addOnClicksHandlers(leadingBreadcrumbs, dispatch, navigateTo, telemetry),
      trailing: addOnClicksHandlers(trailingBreadcrumbs, dispatch, navigateTo, telemetry)
    });
  }, [routeProps, parentLinks, getSecuritySolutionUrl, dispatch, navigateTo, telemetry]);
};
exports.useBreadcrumbsNav = useBreadcrumbsNav;
const getLeadingBreadcrumbs = (parentLinks, getSecuritySolutionUrl) => {
  const landingBreadcrumb = {
    text: _constants.APP_NAME,
    href: getSecuritySolutionUrl({
      deepLinkId: _types.SecurityPageName.landing
    })
  };
  const breadcrumbs = parentLinks.map(({
    title,
    id
  }) => ({
    text: title,
    href: getSecuritySolutionUrl({
      deepLinkId: id
    })
  }));
  return [landingBreadcrumb, ...breadcrumbs];
};
const addOnClicksHandlers = (breadcrumbs, dispatch, navigateTo, telemetry) => breadcrumbs.map(breadcrumb => ({
  ...breadcrumb,
  ...(breadcrumb.href && !breadcrumb.onClick && {
    onClick: createOnClickHandler(breadcrumb.href, dispatch, navigateTo, telemetry, breadcrumb.text)
  })
}));
const createOnClickHandler = (href, dispatch, navigateTo, telemetry, title) => ev => {
  ev.preventDefault();
  if (typeof title === 'string') {
    telemetry.reportEvent(_telemetry.AppEventTypes.BreadcrumbClicked, {
      title
    });
  }
  dispatch(_store.timelineActions.showTimeline({
    id: _timeline.TimelineId.active,
    show: false
  }));
  navigateTo({
    url: href
  });
};