"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiselectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_bool_state = require("../../hooks/use_bool_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/multiselect_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Please use this component instead of [MultiselectFilter](../../../detection_engine/rule_monitoring/components/basic/filters/multiselect_filter/index.tsx)
 *
 * The new version uses `EuiSelectable` instead of the deprecated `EuiFilterSelectItem`. That required a width param, which wasn't previously necessary.
 * It also exports the filter without the `EuiFilterGroup` wrapper, allowing several filters to be grouped.
 *
 * To migrate to the new version, you need to:
 * 1. Wrap it with EuiFilterGroup
 * @example
 * <EuiFilterGroup>
 *   <MultiselectFilter>
 * </EuiFilterGroup>`
 *
 * 2. Provide the desired width
 * @example
 * <MultiselectFilter<MyType> width={150} />
 */
const MultiselectFilterComponent = ({
  'data-test-subj': dataTestSubj = 'multiselectFilter',
  title,
  items,
  selectedItems,
  width,
  onSelectionChange = _lodash.noop,
  renderLabel = String,
  renderItem = renderLabel
}) => {
  const [isPopoverOpen, _unused, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const options = (0, _react.useMemo)(() => {
    const checked = 'on';
    return items.map(item => ({
      originalItem: item,
      label: renderLabel(item),
      checked: selectedItems.includes(item) ? checked : undefined
    }));
  }, [items, renderLabel, selectedItems]);
  const onChange = (0, _react.useCallback)((newItems, _event, changedOption) => {
    var _changedOption$checke;
    onSelectionChange(newItems.filter(({
      checked
    }) => checked === 'on').map(({
      originalItem
    }) => originalItem), changedOption.originalItem, (_changedOption$checke = changedOption.checked) !== null && _changedOption$checke !== void 0 ? _changedOption$checke : 'off');
  }, [onSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": dataTestSubj,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": `${dataTestSubj}-popoverButton`,
      iconType: "arrowDown",
      grow: false,
      numFilters: items.length,
      numActiveFilters: selectedItems.length,
      hasActiveFilters: selectedItems.length > 0,
      isSelected: isPopoverOpen,
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, title),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": `${dataTestSubj}-item`,
    onChange: onChange,
    options: options,
    renderOption: ({
      originalItem
    }) => renderItem(originalItem),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 20
    }
  }, list)));
};
const MultiselectFilter = exports.MultiselectFilter = /*#__PURE__*/_react.default.memo(MultiselectFilterComponent); // The cast is necessary because React.memo does not support generics