"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _label_field = require("./label_field");
var _not_available_prompt = require("./not_available_prompt");
var _kibana = require("../../../../lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/osquery/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OsqueryEditorComponent = ({
  node,
  onSave,
  onCancel
}) => {
  var _node$configuration, _node$configuration2, _node$configuration3;
  const isEditMode = node != null;
  const {
    osquery,
    application: {
      capabilities: {
        osquery: osqueryPermissions
      }
    }
  } = (0, _kibana.useKibana)().services;
  const formMethods = (0, _reactHookForm.useForm)({
    defaultValues: {
      label: node === null || node === void 0 ? void 0 : (_node$configuration = node.configuration) === null || _node$configuration === void 0 ? void 0 : _node$configuration.label,
      query: node === null || node === void 0 ? void 0 : (_node$configuration2 = node.configuration) === null || _node$configuration2 === void 0 ? void 0 : _node$configuration2.query,
      ecs_mapping: node === null || node === void 0 ? void 0 : (_node$configuration3 = node.configuration) === null || _node$configuration3 === void 0 ? void 0 : _node$configuration3.ecs_mapping
    }
  });
  const onSubmit = (0, _react.useCallback)(data => {
    onSave(`!{osquery${JSON.stringify((0, _lodash.pickBy)({
      query: data.query,
      label: data.label,
      ecs_mapping: data.ecs_mapping
    }, value => !(0, _lodash.isEmpty)(value)))}}`, {
      block: true
    });
  }, [onSave]);
  const noOsqueryPermissions = (0, _react.useMemo)(() => (!osqueryPermissions.runSavedQueries || !osqueryPermissions.readSavedQueries) && !osqueryPermissions.writeLiveQueries, [osqueryPermissions.readSavedQueries, osqueryPermissions.runSavedQueries, osqueryPermissions.writeLiveQueries]);
  const OsqueryActionForm = (0, _react.useMemo)(() => {
    if (osquery !== null && osquery !== void 0 && osquery.LiveQueryField) {
      const {
        LiveQueryField
      } = osquery;
      return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, formMethods, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_label_field.LabelField, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(LiveQueryField, {
        formMethods: formMethods,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }));
    }
    return null;
  }, [formMethods, osquery]);
  if (noOsqueryPermissions) {
    return /*#__PURE__*/_react.default.createElement(_not_available_prompt.OsqueryNotAvailablePrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.editModalTitle",
    defaultMessage: "Edit query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.addModalTitle",
    defaultMessage: "Add query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, OsqueryActionForm)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.securitySolution.markdown.osquery.modalCancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: formMethods.handleSubmit(onSubmit),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.addModalConfirmButtonLabel",
    defaultMessage: "Add query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.osquery.editModalConfirmButtonLabel",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }))));
};
const OsqueryEditor = /*#__PURE__*/_react.default.memo(OsqueryEditorComponent);
const plugin = ({
  interactionsUpsellingMessage
}) => {
  return {
    name: 'osquery',
    button: {
      label: interactionsUpsellingMessage !== null && interactionsUpsellingMessage !== void 0 ? interactionsUpsellingMessage : 'Osquery',
      iconType: 'logoOsquery',
      isDisabled: !!interactionsUpsellingMessage
    },
    helpText: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "md",
      fontSize: "l",
      paddingSize: "s",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, '!{osquery{options}}'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    })),
    editor: OsqueryEditor
  };
};
exports.plugin = plugin;