"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filtersToInsightProviders = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildPrimitiveProvider = filter => {
  var _filter$meta$key, _filter$meta, _filter$meta$negate, _filter$meta2, _filter$meta$type, _filter$meta3;
  const field = (_filter$meta$key = (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.key) !== null && _filter$meta$key !== void 0 ? _filter$meta$key : '';
  const excluded = (_filter$meta$negate = (_filter$meta2 = filter.meta) === null || _filter$meta2 === void 0 ? void 0 : _filter$meta2.negate) !== null && _filter$meta$negate !== void 0 ? _filter$meta$negate : false;
  const queryType = (_filter$meta$type = (_filter$meta3 = filter.meta) === null || _filter$meta3 === void 0 ? void 0 : _filter$meta3.type) !== null && _filter$meta$type !== void 0 ? _filter$meta$type : _esQuery.FILTERS.PHRASE;
  const baseFilter = {
    field,
    excluded,
    queryType
  };
  if ((0, _esQuery.isRangeFilter)(filter)) {
    var _filter$meta$type2;
    const {
      gte,
      lt
    } = filter.query.range[field];
    const value = JSON.stringify({
      gte,
      lt
    });
    return {
      ...baseFilter,
      value,
      queryType: (_filter$meta$type2 = filter.meta.type) !== null && _filter$meta$type2 !== void 0 ? _filter$meta$type2 : _esQuery.FILTERS.RANGE
    };
  } else if ((0, _esQuery.isPhrasesFilter)(filter)) {
    var _filter$meta4, _filter$meta$params, _filter$meta5, _filter$meta$type3;
    const typeOfParams = typeof ((_filter$meta4 = filter.meta) === null || _filter$meta4 === void 0 ? void 0 : _filter$meta4.params[0]);
    return {
      ...baseFilter,
      value: JSON.stringify((_filter$meta$params = (_filter$meta5 = filter.meta) === null || _filter$meta5 === void 0 ? void 0 : _filter$meta5.params) !== null && _filter$meta$params !== void 0 ? _filter$meta$params : []),
      valueType: typeOfParams,
      queryType: (_filter$meta$type3 = filter.meta.type) !== null && _filter$meta$type3 !== void 0 ? _filter$meta$type3 : _esQuery.FILTERS.PHRASES
    };
  } else if ((0, _esQuery.isExistsFilter)(filter)) {
    var _filter$meta$type4;
    return {
      ...baseFilter,
      value: '',
      queryType: (_filter$meta$type4 = filter.meta.type) !== null && _filter$meta$type4 !== void 0 ? _filter$meta$type4 : _esQuery.FILTERS.EXISTS
    };
  } else if ((0, _esQuery.isPhraseFilter)(filter)) {
    var _filter$meta6, _filter$meta6$params, _filter$meta$params$q, _filter$meta7, _filter$meta7$params, _filter$meta$type5;
    const valueType = typeof ((_filter$meta6 = filter.meta) === null || _filter$meta6 === void 0 ? void 0 : (_filter$meta6$params = _filter$meta6.params) === null || _filter$meta6$params === void 0 ? void 0 : _filter$meta6$params.query);
    return {
      ...baseFilter,
      value: (_filter$meta$params$q = (_filter$meta7 = filter.meta) === null || _filter$meta7 === void 0 ? void 0 : (_filter$meta7$params = _filter$meta7.params) === null || _filter$meta7$params === void 0 ? void 0 : _filter$meta7$params.query) !== null && _filter$meta$params$q !== void 0 ? _filter$meta$params$q : '',
      valueType,
      queryType: (_filter$meta$type5 = filter.meta.type) !== null && _filter$meta$type5 !== void 0 ? _filter$meta$type5 : _esQuery.FILTERS.PHRASE
    };
  } else {
    return {
      ...baseFilter,
      value: '',
      queryType: _esQuery.FILTERS.PHRASE
    };
  }
};
const nonCombinedToProvider = filters => {
  return filters.map(filter => {
    return buildPrimitiveProvider(filter);
  });
};

/**
 * This function takes an array of Filter types and returns a 2d array
 * of an intermediate data structure called a Provider, which can map from
 * Filter <-> DataProvider. Items in each inner array of the Provider[][]
 * return value are AND'ed together, items in the outer arrays are OR'ed.
 */
const filtersToInsightProviders = filters => {
  const hasCombined = filters.some(_esQuery.isCombinedFilter);
  if (hasCombined === false) {
    return [nonCombinedToProvider(filters)];
  } else {
    const combinedFilterToProviders = filters.reduce((outerFilters, filter) => {
      if ((0, _esQuery.isCombinedFilter)(filter)) {
        const innerFilters = filter.meta.params;
        if (filter.meta.relation === _esQuery.BooleanRelation.OR) {
          const oredFilters = innerFilters.map(f => {
            const oredFilter = filtersToInsightProviders([f]);
            return (0, _lodash.flatten)(oredFilter);
          });
          return [...outerFilters, ...oredFilters];
        } else {
          const innerFiltersToProviders = filtersToInsightProviders(innerFilters);
          return [...outerFilters, ...innerFiltersToProviders];
        }
      } else {
        return [...outerFilters, [buildPrimitiveProvider(filter)]];
      }
    }, []);
    return combinedFilterToProviders;
  }
};
exports.filtersToInsightProviders = filtersToInsightProviders;