"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorToastDispatcher = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _app = require("../../store/app");
var _toasters = require("../toasters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorToastDispatcherComponent = ({
  toastLifeTimeMs = 5000
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getErrorSelector = (0, _react.useMemo)(() => _store.appSelectors.errorsSelector(), []);
  const errors = (0, _use_selector.useDeepEqualSelector)(getErrorSelector);
  const [{
    toasts
  }, dispatchToaster] = (0, _toasters.useStateToaster)();
  (0, _react.useEffect)(() => {
    errors.forEach(({
      id,
      title,
      message
    }) => {
      if (!toasts.some(toast => toast.id === id)) {
        dispatchToaster({
          type: 'addToaster',
          toast: {
            color: 'danger',
            id,
            iconType: 'error',
            title,
            errors: message,
            toastLifeTimeMs
          }
        });
      }
      dispatch(_app.appActions.removeError({
        id
      }));
    });
  }, [dispatch, dispatchToaster, errors, toastLifeTimeMs, toasts]);
  return null;
};
ErrorToastDispatcherComponent.displayName = 'ErrorToastDispatcherComponent';
const ErrorToastDispatcher = exports.ErrorToastDispatcher = /*#__PURE__*/_react.default.memo(ErrorToastDispatcherComponent);