"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoDownload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/auto_download/auto_download.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InvisibleAnchor = _styledComponents.default.a`
  display: none;
`;
const AutoDownload = ({
  blob,
  name,
  onDownload
}) => {
  const anchorRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (blob && anchorRef !== null && anchorRef !== void 0 && anchorRef.current) {
      // @ts-expect-error
      if (typeof window.navigator.msSaveOrOpenBlob === 'function') {
        // @ts-expect-error
        window.navigator.msSaveBlob(blob);
      } else {
        const objectURL = window.URL.createObjectURL(blob);
        anchorRef.current.href = objectURL;
        anchorRef.current.download = name !== null && name !== void 0 ? name : 'download.txt';
        anchorRef.current.click();
        window.URL.revokeObjectURL(objectURL);
      }
      if (onDownload) {
        onDownload();
      }
    }
  }, [blob, name, onDownload]);
  return /*#__PURE__*/_react.default.createElement(InvisibleAnchor, {
    ref: anchorRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  });
};
exports.AutoDownload = AutoDownload;