"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/cloud-defend-plugin/public");
var _kibana = require("../common/lib/kibana");
var _page_wrapper = require("../common/components/page_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _filters_global = require("../common/components/filters_global");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_defend/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This exists only for the type signature cast
const CloudDefendSpyRoute = ({
  pageName,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, (0, _extends2.default)({
  pageName: pageName
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 3
  }
}));
const cloudDefendSecuritySolutionContext = {
  getFiltersGlobalComponent: () => _filters_global.FiltersGlobal,
  getSpyRouteComponent: () => CloudDefendSpyRoute
};
const CloudDefend = () => {
  const {
    cloudDefend
  } = (0, _kibana.useKibana)().services;
  const CloudDefendRouter = cloudDefend.getCloudDefendRouter();
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true,
    noTimeline: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CloudDefendRouter, {
    securitySolutionContext: cloudDefendSecuritySolutionContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })));
};
CloudDefend.displayName = 'CloudDefend';
const routes = exports.routes = [{
  path: _public.CLOUD_DEFEND_BASE_PATH,
  component: CloudDefend
}];