"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = require("react");
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useColumns = ({
  isDisabled,
  isLoading,
  openScheduleDetails,
  enableSchedule,
  disableSchedule,
  deleteSchedule
}) => {
  const onSwitchChange = (0, _react.useCallback)(async (scheduleId, enabled) => {
    if (enabled) {
      await enableSchedule(scheduleId);
    } else {
      await disableSchedule(scheduleId);
    }
  }, [disableSchedule, enableSchedule]);
  return (0, _react.useMemo)(() => [(0, _columns.createNameColumn)({
    openScheduleDetails
  }), (0, _columns.createStatusColumn)(), (0, _columns.createEnableColumn)({
    isDisabled,
    isLoading,
    onSwitchChange
  }), (0, _columns.createActionsColumn)({
    isDisabled,
    deleteSchedule
  })], [deleteSchedule, isDisabled, isLoading, onSwitchChange, openScheduleDetails]);
};
exports.useColumns = useColumns;