"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryTableSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var _asset_inventory_grouping = require("./grouping/asset_inventory_grouping");
var _use_asset_inventory_grouping = require("./grouping/use_asset_inventory_grouping");
var _asset_inventory_data_table = require("./asset_inventory_data_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/asset_inventory_table_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Recursive component hierarchy
 *
 * AssetInventoryTableSection (renders either/or one of the children)
 * |-- AssetInventoryDataTable (no grouping)
 * |-- GroupWithURLPagination (grouping level = 0, renders both children)
 *     |-- GroupWrapper
 *     |-- GroupContent
 *         |-- GroupWithLocalPagination (grouping level = 1, renders both children)
 *             |-- GroupWrapper
 *             |-- GroupContent (renders)
 *                 |-- DataTableWithLocalPagination
 *                     |-- AssetInventoryDataTable (grouping level = 2)
 */
const AssetInventoryTableSection = ({
  state
}) => {
  const {
    grouping
  } = (0, _use_asset_inventory_grouping.useAssetInventoryGrouping)({
    state
  });
  const selectedGroup = grouping.selectedGroups[0];
  if (selectedGroup === 'none') {
    return /*#__PURE__*/_react.default.createElement(_asset_inventory_data_table.AssetInventoryDataTable, {
      state: state,
      groupSelectorComponent: grouping.groupSelector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(GroupWithURLPagination, {
    state: state,
    selectedGroup: selectedGroup,
    selectedGroupOptions: grouping.selectedGroups,
    groupSelectorComponent: grouping.groupSelector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.AssetInventoryTableSection = AssetInventoryTableSection;
const GroupWithURLPagination = ({
  state,
  selectedGroup,
  selectedGroupOptions,
  groupSelectorComponent
}) => {
  const {
    groupData,
    grouping,
    isFetching
  } = (0, _use_asset_inventory_grouping.useAssetInventoryGrouping)({
    state,
    selectedGroup,
    groupFilters: []
  });

  /**
   * This is used to reset the active page index when the selected group changes
   * It is needed because the grouping number of pages can change according to the selected group
   */
  (0, _react.useEffect)(() => {
    state.onChangePage(0);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedGroup]);
  return /*#__PURE__*/_react.default.createElement(_asset_inventory_grouping.GroupWrapper, {
    data: groupData,
    grouping: grouping,
    renderChildComponent: currentGroupFilters => /*#__PURE__*/_react.default.createElement(GroupContent, {
      currentGroupFilters: currentGroupFilters,
      state: state,
      groupingLevel: 1,
      selectedGroupOptions: selectedGroupOptions,
      groupSelectorComponent: groupSelectorComponent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }),
    activePageIndex: state.pageIndex,
    pageSize: state.pageSize,
    onChangeGroupsPage: state.onChangePage,
    onChangeGroupsItemsPerPage: state.onChangeItemsPerPage,
    isFetching: isFetching,
    selectedGroup: selectedGroup,
    groupingLevel: 0,
    groupSelectorComponent: groupSelectorComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
};
/**
 * This function is used to modify the filters for the asset inventory grouping
 * It is needed because the asset.criticality field has a soft delete mechanism
 * So asset.criticality = "deleted" should be excluded from the grouping
 * (treated as a missing value)
 */
const groupFilterMap = filter => {
  var _query$bool, _query$bool$should, _query$bool$should$, _query$bool$should$$b, _query$bool$should$$b2, _query$bool$should$$b3, _query$bool2, _query$bool3;
  const query = filter === null || filter === void 0 ? void 0 : filter.query;
  if ((query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : (_query$bool$should = _query$bool.should) === null || _query$bool$should === void 0 ? void 0 : (_query$bool$should$ = _query$bool$should[0]) === null || _query$bool$should$ === void 0 ? void 0 : (_query$bool$should$$b = _query$bool$should$.bool) === null || _query$bool$should$$b === void 0 ? void 0 : (_query$bool$should$$b2 = _query$bool$should$$b.must_not) === null || _query$bool$should$$b2 === void 0 ? void 0 : (_query$bool$should$$b3 = _query$bool$should$$b2.exists) === null || _query$bool$should$$b3 === void 0 ? void 0 : _query$bool$should$$b3.field) === _constants.ASSET_FIELDS.ASSET_CRITICALITY) {
    var _filter$meta;
    return {
      meta: (_filter$meta = filter === null || filter === void 0 ? void 0 : filter.meta) !== null && _filter$meta !== void 0 ? _filter$meta : {
        alias: null,
        disabled: false,
        negate: false
      },
      query: {
        bool: {
          filter: {
            bool: {
              should: [{
                term: {
                  [_constants.ASSET_FIELDS.ASSET_CRITICALITY]: 'deleted'
                }
              }, {
                bool: {
                  must_not: {
                    exists: {
                      field: _constants.ASSET_FIELDS.ASSET_CRITICALITY
                    }
                  }
                }
              }],
              minimum_should_match: 1
            }
          }
        }
      }
    };
  }
  return query !== null && query !== void 0 && query.match_phrase || query !== null && query !== void 0 && (_query$bool2 = query.bool) !== null && _query$bool2 !== void 0 && _query$bool2.should || query !== null && query !== void 0 && (_query$bool3 = query.bool) !== null && _query$bool3 !== void 0 && _query$bool3.filter ? filter : null;
};
const filterTypeGuard = filter => filter !== null;
const mergeCurrentAndParentFilters = (currentGroupFilters, parentGroupFilters) => {
  return [...currentGroupFilters, ...(parentGroupFilters ? JSON.parse(parentGroupFilters) : [])];
};
const GroupContent = ({
  currentGroupFilters,
  state,
  groupingLevel,
  selectedGroupOptions,
  parentGroupFilters,
  groupSelectorComponent
}) => {
  if (groupingLevel < selectedGroupOptions.length) {
    const nextGroupingLevel = groupingLevel + 1;
    const newParentGroupFilters = mergeCurrentAndParentFilters(currentGroupFilters, parentGroupFilters).map(groupFilterMap).filter(filterTypeGuard);
    return /*#__PURE__*/_react.default.createElement(GroupWithLocalPagination, {
      state: state,
      groupingLevel: nextGroupingLevel,
      selectedGroup: selectedGroupOptions[groupingLevel],
      selectedGroupOptions: selectedGroupOptions,
      parentGroupFilters: JSON.stringify(newParentGroupFilters),
      groupSelectorComponent: groupSelectorComponent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataTableWithLocalPagination, {
    state: state,
    currentGroupFilters: currentGroupFilters,
    parentGroupFilters: parentGroupFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  });
};
const GroupWithLocalPagination = ({
  state,
  groupingLevel,
  parentGroupFilters,
  selectedGroup,
  selectedGroupOptions,
  groupSelectorComponent
}) => {
  const [subgroupPageIndex, setSubgroupPageIndex] = (0, _react.useState)(0);
  const [subgroupPageSize, setSubgroupPageSize] = (0, _react.useState)(10);
  const groupFilters = parentGroupFilters ? JSON.parse(parentGroupFilters) : [];
  const {
    groupData,
    grouping,
    isFetching
  } = (0, _use_asset_inventory_grouping.useAssetInventoryGrouping)({
    state: {
      ...state,
      pageIndex: subgroupPageIndex,
      pageSize: subgroupPageSize
    },
    selectedGroup,
    groupFilters
  });

  /**
   * This is used to reset the active page index when the selected group changes
   * It is needed because the grouping number of pages can change according to the selected group
   */
  (0, _react.useEffect)(() => {
    setSubgroupPageIndex(0);
  }, [selectedGroup]);
  return /*#__PURE__*/_react.default.createElement(_asset_inventory_grouping.GroupWrapper, {
    data: groupData,
    grouping: grouping,
    renderChildComponent: currentGroupFilters => /*#__PURE__*/_react.default.createElement(GroupContent, {
      currentGroupFilters: currentGroupFilters.map(groupFilterMap).filter(filterTypeGuard),
      state: state,
      groupingLevel: groupingLevel,
      selectedGroupOptions: selectedGroupOptions,
      groupSelectorComponent: groupSelectorComponent,
      parentGroupFilters: JSON.stringify(groupFilters),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }),
    activePageIndex: subgroupPageIndex,
    pageSize: subgroupPageSize,
    onChangeGroupsPage: setSubgroupPageIndex,
    onChangeGroupsItemsPerPage: setSubgroupPageSize,
    isFetching: isFetching,
    selectedGroup: selectedGroup,
    groupingLevel: groupingLevel,
    groupSelectorComponent: groupSelectorComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 5
    }
  });
};
const getDataGridFilter = filter => {
  var _filter$query;
  if (!filter) return null;
  return {
    ...((_filter$query = filter === null || filter === void 0 ? void 0 : filter.query) !== null && _filter$query !== void 0 ? _filter$query : {})
  };
};
const DataTableWithLocalPagination = ({
  state,
  currentGroupFilters,
  parentGroupFilters
}) => {
  const [tablePageIndex, setTablePageIndex] = (0, _react.useState)(0);
  const [tablePageSize, setTablePageSize] = (0, _react.useState)(10);
  const combinedFilters = mergeCurrentAndParentFilters(currentGroupFilters, parentGroupFilters).map(groupFilterMap).filter(filterTypeGuard).map(getDataGridFilter).filter(filter => Boolean(filter));
  const newState = {
    ...state,
    query: {
      ...state.query,
      bool: {
        ...state.query.bool,
        filter: [...state.query.bool.filter, ...combinedFilters]
      }
    },
    pageIndex: tablePageIndex,
    pageSize: tablePageSize,
    onChangePage: setTablePageIndex,
    onChangeItemsPerPage: setTablePageSize
  };
  return /*#__PURE__*/_react.default.createElement(_asset_inventory_data_table.AssetInventoryDataTable, {
    state: newState,
    height: _constants.DEFAULT_TABLE_SECTION_HEIGHT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 10
    }
  });
};