"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("../../common/images/illustration_product_no_results_magnifying_glass.svg"));
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/asset_inventory_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AssetInventoryEmptyState = ({
  onResetFilters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: (0, _react2.css)`
        max-width: 734px;
        && > .euiEmptyPrompt__main {
          gap: ${euiTheme.size.xl};
        }
        && {
          margin-top: ${euiTheme.size.xxxl}};
        }
      `,
    "data-test-subj": _constants.TEST_SUBJ_EMPTY_STATE,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: _illustration_product_no_results_magnifying_glass.default,
      alt: _i18n.i18n.translate('xpack.securitySolution.assetInventory.emptyState.illustrationAlt', {
        defaultMessage: 'No results'
      }),
      css: (0, _react2.css)`
            width: 290px;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.title",
      defaultMessage: "No results match your search criteria",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.description",
      defaultMessage: "Try modifying your search or filter set",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onResetFilters,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.resetFiltersButton",
      defaultMessage: "Reset filters",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _constants.DOCS_URL,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.emptyState.readDocsLink",
      defaultMessage: "Read the docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  });
};
exports.AssetInventoryEmptyState = AssetInventoryEmptyState;