"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAttachmentUiDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extension of UnknownAttachment that includes an optional attachmentLabel field in the data property
 */

const ATTACHMENT_TYPE_CONFIGS = [{
  type: _constants.SecurityAgentBuilderAttachments.alert,
  label: _i18n.i18n.translate('xpack.securitySolution.agentBuilder.attachments.alert.label', {
    defaultMessage: 'Security Alert'
  }),
  icon: 'bell'
}, {
  type: _constants.SecurityAgentBuilderAttachments.entity,
  label: _i18n.i18n.translate('xpack.securitySolution.agentBuilder.attachments.entity.label', {
    defaultMessage: 'Risk Entity'
  }),
  icon: 'user'
}, {
  type: _constants.SecurityAgentBuilderAttachments.rule,
  label: _i18n.i18n.translate('xpack.securitySolution.agentBuilder.attachments.rule.label', {
    defaultMessage: 'Security Rule'
  }),
  icon: 'document'
}];
const createAttachmentTypeConfig = (defaultLabel, icon) => ({
  getLabel: attachment => {
    var _attachment$data;
    const attachmentLabel = attachment === null || attachment === void 0 ? void 0 : (_attachment$data = attachment.data) === null || _attachment$data === void 0 ? void 0 : _attachment$data.attachmentLabel;
    return attachmentLabel !== null && attachmentLabel !== void 0 ? attachmentLabel : defaultLabel;
  },
  getIcon: () => icon
});
const registerAttachmentUiDefinitions = ({
  attachments
}) => {
  ATTACHMENT_TYPE_CONFIGS.forEach(({
    type,
    label,
    icon
  }) => {
    attachments.addAttachmentType(type, createAttachmentTypeConfig(label, icon));
  });
};
exports.registerAttachmentUiDefinitions = registerAttachmentUiDefinitions;