"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modify = modify;
var _fp = _interopRequireDefault(require("lodash/fp"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Proxy for lodash fp `update` with better type inference.
 * We use `modify` to signal that the type of the object is being modified.
 * Overloaded to support both imperative and point free style.
 */

function modify(...args) {
  if (args.length === 3) {
    const [obj, path, updater] = args;
    return _fp.default.update(path)(updater)(obj);
  }
  const [path, updater] = args;
  return _fp.default.update(path)(updater);
}