"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMigrationPrebuiltRule = exports.isMigrationCustomRule = exports.convertMigrationCustomRuleToSecurityRulePayload = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMigrationPrebuiltRule = rule => !!(rule !== null && rule !== void 0 && rule.title && rule !== null && rule !== void 0 && rule.description && rule !== null && rule !== void 0 && rule.prebuilt_rule_id);
exports.isMigrationPrebuiltRule = isMigrationPrebuiltRule;
const isMigrationCustomRule = rule => !isMigrationPrebuiltRule(rule) && !!(rule !== null && rule !== void 0 && rule.title && rule !== null && rule !== void 0 && rule.description && rule !== null && rule !== void 0 && rule.query && rule !== null && rule !== void 0 && rule.query_language);
exports.isMigrationCustomRule = isMigrationCustomRule;
const convertMigrationCustomRuleToSecurityRulePayload = (rule, enabled) => {
  var _rule$threat;
  return {
    type: rule.query_language,
    language: rule.query_language,
    query: rule.query,
    name: rule.title,
    description: rule.description,
    enabled,
    severity: rule.severity,
    risk_score: rule.risk_score,
    threat: (_rule$threat = rule.threat) !== null && _rule$threat !== void 0 ? _rule$threat : [],
    ..._constants.DEFAULT_TRANSLATION_FIELDS
  };
};
exports.convertMigrationCustomRuleToSecurityRulePayload = convertMigrationCustomRuleToSecurityRulePayload;