"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QRadarMitreRequest = exports.QRadarMitreMappingsData = exports.QRadarMitreMappingTechnique = exports.QRadarMitreMappingTactic = exports.QRadarMitreMappingRule = exports.EnhanceQRadarRule = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: QRadar Vendor Rule Enhancement Schema
 *   version: 1.0.0
 */

const QRadarMitreMappingTechnique = exports.QRadarMitreMappingTechnique = _zod.z.object({
  confidence: _zod.z.string().optional(),
  enabled: _zod.z.boolean(),
  id: _zod.z.string()
});
const QRadarMitreMappingTactic = exports.QRadarMitreMappingTactic = _zod.z.object({
  confidence: _zod.z.string().optional(),
  user_override: _zod.z.boolean().optional(),
  enabled: _zod.z.boolean(),
  ibm_default: _zod.z.boolean().optional(),
  name: _zod.z.string(),
  techniques: _zod.z.object({}).catchall(QRadarMitreMappingTechnique).optional()
});
const QRadarMitreMappingRule = exports.QRadarMitreMappingRule = _zod.z.object({
  id: _zod.z.string(),
  has_ibm_default: _zod.z.boolean().optional(),
  last_updated: _zod.z.number().optional(),
  mapping: _zod.z.object({}).catchall(QRadarMitreMappingTactic),
  'min-mitre-version': _zod.z.number().optional()
});

/**
 * QRadar MITRE mappings data keyed by rule name
 */

const QRadarMitreMappingsData = exports.QRadarMitreMappingsData = _zod.z.object({}).catchall(QRadarMitreMappingRule);

/**
 * Request to enhance rules with QRadar MITRE mappings
 */

const QRadarMitreRequest = exports.QRadarMitreRequest = _zod.z.object({
  /**
   * The vendor identifier
   */
  vendor: _zod.z.literal('qradar'),
  /**
   * The type of enhancement data
   */
  type: _zod.z.literal('mitre'),
  /**
   * QRadar MITRE mappings data keyed by rule name
   */
  data: QRadarMitreMappingsData
});

/**
 * Union type for QRadar rule enhancements
 */

const EnhanceQRadarRule = exports.EnhanceQRadarRule = QRadarMitreRequest;