"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationVendorEnum = exports.SiemMigrationVendor = exports.SiemMigrationResourceType = exports.SiemMigrationResourceData = exports.SiemMigrationResourceContent = exports.SiemMigrationResourceBase = exports.SiemMigrationResource = exports.MigrationTranslationStats = exports.MigrationTranslationResultEnum = exports.MigrationTranslationResult = exports.MigrationTaskStatusEnum = exports.MigrationTaskStatus = exports.MigrationTaskStats = exports.MigrationTaskItemsStats = exports.MigrationStatusEnum = exports.MigrationStatus = exports.MigrationLastExecution = exports.MigrationComments = exports.MigrationComment = exports.LangSmithOptions = exports.LangSmithEvaluationOptions = exports.ConnectorId = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("../../api/model/primitives.gen");
var _splunk = require("./vendor/common/splunk.gen");
var _qradar = require("./vendor/common/qradar.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Migration common components
 *   version: not applicable
 */

/**
 * The GenAI connector id to use.
 */

const ConnectorId = exports.ConnectorId = _zod.z.string();

/**
 * The LangSmith options object.
 */

const LangSmithOptions = exports.LangSmithOptions = _zod.z.object({
  /**
   * The project name.
   */
  project_name: _zod.z.string(),
  /**
   * The API key to use for tracing.
   */
  api_key: _zod.z.string()
});

/**
 * The LangSmith settings object for evaluations.
 */

const LangSmithEvaluationOptions = exports.LangSmithEvaluationOptions = LangSmithOptions.merge(_zod.z.object({
  /**
   * The dataset name to use for evaluations.
   */
  dataset: _zod.z.string()
}));

/**
 * The vendor identifier.
 */

const SiemMigrationVendor = exports.SiemMigrationVendor = _zod.z.enum(['splunk', 'qradar']);
const SiemMigrationVendorEnum = exports.SiemMigrationVendorEnum = SiemMigrationVendor.enum;

/**
 * A comment for the migration process
 */

const MigrationComment = exports.MigrationComment = _zod.z.object({
  /**
   * The message of the migration comment
   */
  message: _zod.z.string(),
  /**
   * The moment of creation of the comment
   */
  created_at: _zod.z.string(),
  /**
   * The user profile ID of the user who created the comment, or `assistant` if it was generated by the LLM
   */
  created_by: _zod.z.string()
});

/**
 * The comments for the migration including a summary from the LLM in markdown.
 */

const MigrationComments = exports.MigrationComments = _zod.z.array(MigrationComment);

/**
 * The status of migration.
 */

const MigrationStatus = exports.MigrationStatus = _zod.z.enum(['pending', 'processing', 'completed', 'failed']);
const MigrationStatusEnum = exports.MigrationStatusEnum = MigrationStatus.enum;

/**
 * The status of the migration task.
 */

const MigrationTaskStatus = exports.MigrationTaskStatus = _zod.z.enum(['ready', 'running', 'stopped', 'finished', 'interrupted']);
const MigrationTaskStatusEnum = exports.MigrationTaskStatusEnum = MigrationTaskStatus.enum;

/**
 * The last execution of a migration task.
 */

const MigrationLastExecution = exports.MigrationLastExecution = _zod.z.object({
  /**
   * The total execution time in milliseconds for the migration. This includes duration of last_execution and any previous executions.
   */
  total_execution_time_ms: _zod.z.number().int().optional(),
  /**
   * The moment the last execution started.
   */
  started_at: _zod.z.string().optional(),
  /**
   * The moment the last execution finished.
   */
  finished_at: _zod.z.string().nullable().optional(),
  /**
   * The connector ID used for the last execution.
   */
  connector_id: _zod.z.string().optional(),
  /**
   * The error message if the last execution failed.
   */
  error: _zod.z.string().nullable().optional(),
  /**
   * Indicates if the last execution was stopped by the user.
   */
  is_stopped: _zod.z.boolean().optional()
});

/**
 * The items migration translation stats object.
 */

const MigrationTranslationStats = exports.MigrationTranslationStats = _zod.z.object({
  /**
   * The migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The items migration translation stats.
   */
  items: _zod.z.object({
    /**
     * The total number of items in the migration.
     */
    total: _zod.z.number().int(),
    /**
     * The number of items that have been successfully translated.
     */
    success: _zod.z.object({
      /**
       * The total number of items that have been successfully translated.
       */
      total: _zod.z.number().int(),
      /**
       * The translation results
       */
      result: _zod.z.object({
        /**
         * The number of items that have been fully translated.
         */
        full: _zod.z.number().int(),
        /**
         * The number of items that have been partially translated.
         */
        partial: _zod.z.number().int(),
        /**
         * The number of items that could not be translated.
         */
        untranslatable: _zod.z.number().int()
      }),
      /**
       * The number of items that have been successfully translated and can be installed.
       */
      installable: _zod.z.number().int()
    }),
    /**
     * The number of items that have failed translation.
     */
    failed: _zod.z.number().int()
  })
});

/**
 * The migration translation result.
 */

const MigrationTranslationResult = exports.MigrationTranslationResult = _zod.z.enum(['full', 'partial', 'untranslatable']);
const MigrationTranslationResultEnum = exports.MigrationTranslationResultEnum = MigrationTranslationResult.enum;

/**
 * The migration items stats.
 */

const MigrationTaskItemsStats = exports.MigrationTaskItemsStats = _zod.z.object({
  /**
   * The total number of items to migrate.
   */
  total: _zod.z.number().int(),
  /**
   * The number of items that are pending migration.
   */
  pending: _zod.z.number().int(),
  /**
   * The number of items that are being migrated.
   */
  processing: _zod.z.number().int(),
  /**
   * The number of items that have been migrated successfully.
   */
  completed: _zod.z.number().int(),
  /**
   * The number of items that have failed migration.
   */
  failed: _zod.z.number().int()
});

/**
 * The migration task stats object.
 */

const MigrationTaskStats = exports.MigrationTaskStats = _zod.z.object({
  /**
   * The migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migration name
   */
  name: _primitives.NonEmptyString,
  /**
   * Indicates if the migration task status.
   */
  status: MigrationTaskStatus,
  /**
   * The migration items stats.
   */
  items: MigrationTaskItemsStats,
  /**
   * The moment the migration was created.
   */
  created_at: _zod.z.string(),
  /**
   * The moment of the last update.
   */
  last_updated_at: _zod.z.string(),
  /**
   * The last execution of the migration task.
   */
  last_execution: MigrationLastExecution.optional(),
  /**
   * The migration vendor.
   */
  vendor: SiemMigrationVendor.optional()
});
const SiemMigrationResourceType = exports.SiemMigrationResourceType = _zod.z.union([_splunk.SplunkResourceType, _qradar.QradarResourceType]);

/**
 * A resource of a migration
 */

const SiemMigrationResourceBase = exports.SiemMigrationResourceBase = _zod.z.object({
  type: SiemMigrationResourceType,
  /**
   * The name of the resource
   */
  name: _primitives.NonEmptyString
});
const SiemMigrationResourceContent = exports.SiemMigrationResourceContent = _zod.z.object({
  /**
   * The resource content value. Can be an empty string.
   */
  content: _zod.z.string(),
  /**
   * The resource arbitrary metadata.
   */
  metadata: _zod.z.object({}).optional()
});

/**
 * The rule migration resource data.
 */

const SiemMigrationResourceData = exports.SiemMigrationResourceData = SiemMigrationResourceBase.merge(SiemMigrationResourceContent);

/**
 * The rule migration resource document object.
 */

const SiemMigrationResource = exports.SiemMigrationResource = SiemMigrationResourceBase.merge(SiemMigrationResourceContent.partial()).merge(_zod.z.object({
  /**
   * The rule resource migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migration id
   */
  migration_id: _primitives.NonEmptyString,
  /**
   * The moment of the last update
   */
  updated_at: _zod.z.string().optional(),
  /**
   * The user who last updated the resource
   */
  updated_by: _zod.z.string().optional()
}));