"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScoreKpiRequestOptionsSchema = void 0;
var _zod = require("@kbn/zod");
var _request_basic_options = require("../model/request_basic_options");
var _risk_score_entity = require("./model/risk_score_entity");
var _factory_query_type = require("../model/factory_query_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScoreKpiRequestOptionsSchema = exports.riskScoreKpiRequestOptionsSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  entity: _zod.z.union([_risk_score_entity.riskScoreEntity, _risk_score_entity.riskScoreEntityArray]),
  factoryQueryType: _zod.z.literal(_factory_query_type.EntityRiskQueries.kpi)
});