"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityDetailsHighlightsResponse = exports.EntityDetailsHighlightsRequestBody = void 0;
var _zod = require("@kbn/zod");
var _bulk_crud_anonymization_fields_route = require("@kbn/elastic-assistant-common/impl/schemas/anonymization_fields/bulk_crud_anonymization_fields_route.gen");
var _common_attributes = require("@kbn/elastic-assistant-common/impl/schemas/conversations/common_attributes.gen");
var _common = require("../entity_store/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Entity Details highlights
 *   version: 1
 */

const EntityDetailsHighlightsRequestBody = exports.EntityDetailsHighlightsRequestBody = _zod.z.object({
  entityType: _common.EntityType,
  /**
   * The identifier of the entity.
   */
  entityIdentifier: _zod.z.string(),
  anonymizationFields: _zod.z.array(_bulk_crud_anonymization_fields_route.AnonymizationFieldResponse),
  /**
   * The 'from' date.
   */
  from: _zod.z.number(),
  /**
   * The 'to' date.
   */
  to: _zod.z.number(),
  /**
   * The connector id.
   */
  connectorId: _zod.z.string()
});
const EntityDetailsHighlightsResponse = exports.EntityDetailsHighlightsResponse = _zod.z.object({
  /**
   * The highlights of the entity.
   */
  summary: _zod.z.object({
    assetCriticality: _zod.z.array(_zod.z.object({})).optional(),
    riskScore: _zod.z.array(_zod.z.object({})).optional(),
    vulnerabilities: _zod.z.array(_zod.z.object({})).optional(),
    vulnerabilitiesTotal: _zod.z.object({}).catchall(_zod.z.number()).optional(),
    anomalies: _zod.z.array(_zod.z.object({})).optional()
  }),
  replacements: _common_attributes.Replacements,
  /**
   * The prompt used to generate the highlights.
   */
  prompt: _zod.z.string()
});