"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV5BaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecurityV5BaseKibanaFeature = ({
  savedObjects
}) => ({
  id: _constants.SECURITY_FEATURE_ID_V5,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.securityGroupDescription', {
    defaultMessage: "Each sub-feature privilege in this group must be assigned individually. Global assignment is only supported if your pricing plan doesn't allow individual feature privileges."
  }),
  privileges: {
    all: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', _constants.LISTS_API_ALL, _constants.LISTS_API_READ, _constants.LISTS_API_SUMMARY, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION],
      savedObject: {
        all: ['alert', ...savedObjects],
        read: []
      },
      ui: [_constants.SECURITY_UI_SHOW, _constants.SECURITY_UI_CRUD]
    },
    read: {
      app: [_constants.APP_ID, _constants.CLOUD_POSTURE_APP_ID, _constants.CLOUD_DEFEND_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'rac', _constants.LISTS_API_READ, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION],
      savedObject: {
        all: [],
        read: [...savedObjects]
      },
      ui: [_constants.SECURITY_UI_SHOW]
    }
  }
});
exports.getSecurityV5BaseKibanaFeature = getSecurityV5BaseKibanaFeature;