"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesBaseKibanaFeature = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_RULE_TYPES = [_constants.LEGACY_NOTIFICATIONS_ID, _securitysolutionRules.ESQL_RULE_TYPE_ID, _securitysolutionRules.EQL_RULE_TYPE_ID, _securitysolutionRules.INDICATOR_RULE_TYPE_ID, _securitysolutionRules.ML_RULE_TYPE_ID, _securitysolutionRules.QUERY_RULE_TYPE_ID, _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID, _securitysolutionRules.THRESHOLD_RULE_TYPE_ID, _securitysolutionRules.NEW_TERMS_RULE_TYPE_ID];
const alertingFeatures = SECURITY_RULE_TYPES.map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_constants.SERVER_APP_ID]
}));
const getRulesBaseKibanaFeature = params => ({
  id: _constants.RULES_FEATURE_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionRolesTitle', {
    defaultMessage: 'Rules'
  }),
  order: 1100,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.RULES_FEATURE_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  alerting: alertingFeatures,
  management: {
    insightsAndAlerting: ['triggersActions'] // Access to the stack rules management UI
  },
  privileges: {
    all: {
      app: [_constants.RULES_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: params.savedObjects,
        read: params.savedObjects
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions'] // Access to the stack rules management UI
      },
      ui: [_constants.RULES_UI_READ, _constants.RULES_UI_EDIT],
      api: [_constants.RULES_API_ALL, _constants.RULES_API_READ, _constants.ALERTS_API_ALL, _constants.ALERTS_API_READ, _constants.EXCEPTIONS_API_ALL, _constants.EXCEPTIONS_API_READ, _constants.LISTS_API_ALL, _constants.LISTS_API_READ, _constants.LISTS_API_SUMMARY, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION, 'rac']
    },
    read: {
      app: [_constants.RULES_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: [],
        read: params.savedObjects
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions'] // Access to the stack rules management UI
      },
      ui: [_constants.RULES_UI_READ],
      api: [_constants.RULES_API_READ, _constants.ALERTS_API_READ, _constants.EXCEPTIONS_API_READ, _constants.LISTS_API_READ, _constants.USERS_API_READ, _constants.INITIALIZE_SECURITY_SOLUTION, 'rac']
    }
  }
});
exports.getRulesBaseKibanaFeature = getRulesBaseKibanaFeature;