"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _deeplinksManagement = require("@kbn/deeplinks-management");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNavigationTree = (services, chatExperience = _aiAssistantCommon.AIChatExperience.Classic) => {
  var _services$cloud;
  return {
    body: [{
      id: 'security_solution_home',
      icon: 'logoSecurity',
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      renderAs: 'home',
      title: _translations.SOLUTION_NAME
    }, {
      link: 'discover',
      icon: 'discoverApp'
    }, _navigation_tree.defaultNavigationTree.dashboards(), _navigation_tree.defaultNavigationTree.rules(), services.featureFlags.getBooleanValue(_securitySolutionNavigation.ATTACKS_ALERTS_ALIGNMENT_ENABLED, false) ? _navigation_tree.defaultNavigationTree.alertDetections() : {
      id: _securitySolutionNavigation.SecurityPageName.alerts,
      icon: 'warning',
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alerts)
    }, {
      // TODO: update icon from EUI
      icon: _navigation_tree.LazyIconWorkflow,
      link: 'workflows',
      badgeType: 'techPreview'
    }, ...(chatExperience === _aiAssistantCommon.AIChatExperience.Agent ? [{
      // TODO: update icon to 'robot' once it's available in EUI
      icon: _navigation_tree.LazyIconAgentBuilder,
      link: 'agent_builder'
    }] : []), {
      id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
      icon: 'bolt',
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery)
    }, {
      id: _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings,
      // TODO change this to the `bullseye` EUI icon when available
      icon: _navigation_tree.LazyIconFindings,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings)
    }, _navigation_tree.defaultNavigationTree.cases(), _navigation_tree.defaultNavigationTree.entityAnalytics(), _navigation_tree.defaultNavigationTree.explore(), _navigation_tree.defaultNavigationTree.investigations(), {
      id: _securitySolutionNavigation.SecurityPageName.threatIntelligence,
      // TODO change this to the `compute` EUI icon when available
      icon: _navigation_tree.LazyIconIntelligence,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.threatIntelligence)
    }, {
      id: _securitySolutionNavigation.SecurityPageName.assetInventory,
      icon: 'editorChecklist',
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.assetInventory)
    }, _navigation_tree.defaultNavigationTree.assets(services), _navigation_tree.defaultNavigationTree.ml()],
    footer: [{
      id: 'launchpad',
      title: _links.i18nStrings.launchPad.title,
      renderAs: 'panelOpener',
      icon: 'launch',
      children: [{
        children: [{
          id: _securitySolutionNavigation.SecurityPageName.landing,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing)
        }, {
          id: _securitySolutionNavigation.SecurityPageName.siemReadiness,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemReadiness)
        }, {
          // value report
          id: _securitySolutionNavigation.SecurityPageName.aiValue,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.aiValue)
        }]
      }, {
        title: _links.i18nStrings.launchPad.migrations.title,
        children: [{
          id: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsRules)
        }, {
          id: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards)
        }]
      }]
    }, {
      link: 'dev_tools',
      title: _links.i18nStrings.devTools,
      icon: 'editorCodeBlock'
    }, {
      id: _deeplinksManagement.DATA_MANAGEMENT_NAV_ID,
      title: _links.i18nStrings.ingestAndManageData.title,
      icon: 'database',
      breadcrumbStatus: 'hidden',
      renderAs: 'panelOpener',
      children: [{
        title: _links.i18nStrings.ingestAndManageData.ingestAndIntegrations.title,
        children: [{
          link: 'integrations'
        },
        // TODO: Add fleet back when it is possible to not jump to  fleet sub menu under assets
        // { link: 'fleet' },
        {
          link: 'management:ingest_pipelines'
        },
        // logstash pipeline
        {
          link: 'management:pipelines'
        }, {
          link: 'management:content_connectors'
        }]
      }, {
        title: _links.i18nStrings.ingestAndManageData.indicesAndDataStreams.title,
        children: [{
          link: 'streams'
        }, {
          link: 'management:index_management'
        }, {
          link: 'management:index_lifecycle_management'
        }, {
          link: 'management:snapshot_restore'
        }, {
          link: 'management:transform'
        }, {
          link: 'management:rollup_jobs'
        }, {
          link: 'management:data_quality'
        }]
      }]
    }, {
      id: _deeplinksManagement.STACK_MANAGEMENT_NAV_ID,
      title: _links.i18nStrings.stackManagementV2.title,
      icon: 'gear',
      breadcrumbStatus: 'hidden',
      renderAs: 'panelOpener',
      children: [{
        id: 'stack_management_home',
        breadcrumbStatus: 'hidden',
        children: [{
          // We include this link here to ensure that the settings icon does not land on Stack Monitoring by default
          // https://github.com/elastic/kibana/issues/241518
          // And that the sidenav panel opens when user lands to legacy management landing page
          // https://github.com/elastic/kibana/issues/240275
          link: 'management',
          title: _links.i18nStrings.stackManagementV2.home.title,
          breadcrumbStatus: 'hidden'
        },
        // Only show Cloud Connect in on-prem deployments (not cloud)
        ...((_services$cloud = services.cloud) !== null && _services$cloud !== void 0 && _services$cloud.isCloudEnabled ? [] : [{
          id: 'cloud_connect',
          link: 'cloud_connect'
        }]), {
          link: 'monitoring'
        }]
      }, {
        title: _links.i18nStrings.stackManagementV2.alertsAndInsights.title,
        children: [{
          link: 'management:triggersActions'
        }, {
          link: 'management:cases'
        }, {
          link: 'management:triggersActionsConnectors'
        }, {
          link: 'management:reporting'
        }, {
          link: 'management:jobsListLink'
        }, {
          link: 'management:watcher'
        }, {
          link: 'management:maintenanceWindows'
        }, {
          id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement)
        }, {
          id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement)
        }]
      }, {
        title: _links.i18nStrings.ml.title,
        children: [{
          link: 'management:overview'
        }, {
          link: 'management:anomaly_detection'
        }, {
          link: 'management:analytics'
        }, {
          link: 'management:trained_models'
        }, {
          link: 'management:supplied_configurations'
        }]
      }, {
        title: _links.i18nStrings.stackManagement.ai.title,
        children: [{
          link: 'management:genAiSettings'
        }, {
          link: 'management:aiAssistantManagementSelection'
        }]
      }, {
        title: _links.i18nStrings.stackManagementV2.security.title,
        children: [{
          link: 'management:users'
        }, {
          link: 'management:roles'
        }, {
          link: 'management:api_keys'
        }, {
          link: 'management:role_mappings'
        }]
      }, {
        title: _links.i18nStrings.stackManagementV2.data.title,
        children: [{
          link: 'management:cross_cluster_replication'
        }, {
          link: 'management:remote_clusters'
        }, {
          link: 'management:migrate_data'
        }]
      }, {
        title: _links.i18nStrings.stackManagementV2.kibana.title,
        children: [{
          link: 'management:dataViews'
        }, {
          link: 'management:filesManagement'
        }, {
          link: 'management:objects'
        }, {
          link: 'management:tags'
        }, {
          link: 'management:search_sessions'
        }, {
          link: 'management:spaces'
        }, {
          link: 'maps'
        }, {
          link: 'visualize'
        }, {
          link: 'graph'
        }, {
          link: 'canvas'
        }, {
          link: 'management:settings'
        }]
      }, {
        title: _links.i18nStrings.stackManagement.stack.title,
        children: [{
          link: 'management:license_management'
        }, {
          link: 'management:upgrade_assistant'
        }]
      }]
    }]
  };
};
exports.createNavigationTree = createNavigationTree;