"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenObject = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Slightly modified to have key/value exposed as Object.
const flattenObject = (item, accDefault = {}, parentKey) => {
  if (item) {
    const isArrayWithSingleValue = Array.isArray(item) && item.length === 1;
    return Object.keys(item).sort().reduce((acc, key) => {
      const childKey = isArrayWithSingleValue ? '' : key;
      const currentKey = (0, _lodash.compact)([parentKey, childKey]).join('.');
      const value = item[key];
      if ((0, _lodash.isObject)(value)) {
        flattenObject(value, acc, currentKey);
      } else {
        acc[currentKey] = value;
      }
      return acc;
    }, accDefault);
  }
  return {};
};
exports.flattenObject = flattenObject;