"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityApiClients = exports.SecurityApiClientsProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a collection of the high-level abstractions (clients) to interact with the Security specific APIs.
 */

/**
 * The `SecurityApiClientsProvider` React context provider is used to provide UI components with the Security API
 * clients that can be subsequently consumed through `useSecurityApiClients` hook.
 */
const [SecurityApiClientsProvider, useSecurityApiClients] = (0, _constate.default)(({
  userProfiles,
  users
}) => ({
  userProfiles,
  users
}));
exports.useSecurityApiClients = useSecurityApiClients;
exports.SecurityApiClientsProvider = SecurityApiClientsProvider;