"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lib = require("../../../lib");
var _shard_details_tree = require("./shard_details_tree");
var _percentage_badge = require("../../percentage_badge");
var _styles = require("../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/profile_tree/shard_details/shard_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  return {
    // Shard header flex item alignment
    shardHeaderFlexItem: (0, _react2.css)`
      align-self: center;
    `,
    // Shard details link styling
    shardDetails: (0, _styles.useSharedDetailsStyles)().shardDetails,
    // Dim styling for shard details
    shardDetailsDim: (0, _styles.useSharedDetailsStyles)().shardDetailsDim
  };
};
const hasVisibleOperation = ops => {
  for (const op of ops) {
    var _op$children;
    if (op.visible) {
      return true;
    }
    if ((_op$children = op.children) !== null && _op$children !== void 0 && _op$children.length && hasVisibleOperation(op.children)) {
      return true;
    }
  }
  return false;
};
const ShardDetails = ({
  index,
  shard,
  operations
}) => {
  const {
    relative,
    time
  } = shard;
  const styles = useStyles();
  const [shardVisibility, setShardVisibility] = (0, _react.useState)(() => hasVisibleOperation(operations.map(op => {
    var _op$treeRoot;
    return (_op$treeRoot = op.treeRoot) !== null && _op$treeRoot !== void 0 ? _op$treeRoot : op;
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.shardHeaderFlexItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: styles.shardDetails,
    onClick: () => setShardVisibility(!shardVisibility),
    "data-test-subj": "openCloseShardDetails",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: shardVisibility ? 'arrowDown' : 'arrowRight',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }), "[", shard.id[0], "][", shard.id[2], "]")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.shardHeaderFlexItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: styles.shardDetailsDim,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
    timePercentage: String(relative),
    label: (0, _lib.msToPretty)(time, 3),
    valueType: 'time',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })))), shardVisibility ? operations.map((data, idx) => /*#__PURE__*/_react.default.createElement(_shard_details_tree.ShardDetailTree, {
    key: idx,
    index: index,
    shard: shard,
    data: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })) : null);
};
exports.ShardDetails = ShardDetails;