"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSynonymsSetModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_synonyms_set = require("../../hooks/use_delete_synonyms_set");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/synonym_sets/delete_synonyms_set_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteSynonymsSetModal = ({
  closeDeleteModal,
  synonymsSetId
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [error, setError] = (0, _react.useState)(null);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccess = () => {
    setIsLoading(false);
    closeDeleteModal();
  };
  const onError = errorMessage => {
    setIsLoading(false);
    setError(errorMessage);
  };
  const {
    mutate: deleteEndpoint
  } = (0, _use_delete_synonyms_set.useDeleteSynonymsSet)(onSuccess, onError);
  const deleteOperation = () => {
    setIsLoading(true);
    deleteEndpoint({
      synonymsSetId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymsSetModal.title', {
      defaultMessage: 'Delete synonyms set'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: closeDeleteModal,
    onConfirm: deleteOperation,
    cancelButtonText: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymsSetModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymsSetModal.confirmButton', {
      defaultMessage: 'Delete'
    }),
    buttonColor: "danger",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.searchSynonyms.deleteSynonymsSetModal.body', {
    defaultMessage: 'Deleting a synonym set currently in use will cause failures in the ingest and query attempts targeting the related semantic text fields.'
  }), error && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "s",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, error));
};
exports.DeleteSynonymsSetModal = DeleteSynonymsSetModal;