"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSynonymsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _common = require("../../../common");
var _doc_links = require("../../../common/doc_links");
var _use_kibana = require("../../hooks/use_kibana");
var _synonym_sets = require("../synonym_sets/synonym_sets");
var _use_fetch_synonyms_sets = require("../../hooks/use_fetch_synonyms_sets");
var _use_synonyms_breadcrumbs = require("../../hooks/use_synonyms_breadcrumbs");
var _empty_prompt = require("../empty_prompt/empty_prompt");
var _create_new_set_modal = require("../synonym_sets/create_new_set_modal");
var _error_prompt = require("../error_prompt/error_prompt");
var _synonyms_utils = require("../../utils/synonyms_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_synonyms/public/components/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchSynonymsOverview = () => {
  const {
    services: {
      console: consolePlugin,
      history,
      searchNavigation
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: synonymsData,
    isInitialLoading,
    isError,
    error
  } = (0, _use_fetch_synonyms_sets.useFetchSynonymsSets)();
  const [isCreateModalVisible, setIsCreateModalVisible] = (0, _react.useState)(false);
  (0, _use_synonyms_breadcrumbs.useSynonymsBreadcrumbs)();
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    grow: false,
    "data-test-subj": "searchSynonymsOverviewPage",
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, !isInitialLoading && !isError && (synonymsData === null || synonymsData === void 0 ? void 0 : synonymsData._meta.totalItemCount) !== 0 && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: _common.PLUGIN_TITLE,
    restrictWidth: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "searchSynonymsSearchSynonymsOverviewApiDocumentationLink",
      external: true,
      target: "_blank",
      href: _doc_links.docLinks.synonymsApi,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchSynonyms.synonymsSetDetail.documentationLink",
      defaultMessage: "API Documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "searchSynonymsSearchSynonymsOverviewCreateButton",
      fill: true,
      iconType: "plusInCircle",
      onClick: () => {
        setIsCreateModalVisible(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchSynonyms.synonymsSetDetail.createButton",
      defaultMessage: "Create",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 19
      }
    }))))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchSynonyms.synonymsSetDetail.description",
    defaultMessage: "Create and manage synonym sets and synonym rules.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    contentProps: {
      css: (0, _react2.css)({
        height: '100%'
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, isCreateModalVisible && /*#__PURE__*/_react.default.createElement(_create_new_set_modal.CreateSynonymsSetModal, {
    onClose: () => {
      setIsCreateModalVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 30
    }
  }), isError && /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
    errorType: (0, _synonyms_utils.isPermissionError)(error) ? 'missingPermissions' : 'generic',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }), !isInitialLoading && synonymsData && synonymsData._meta.totalItemCount > 0 && /*#__PURE__*/_react.default.createElement(_synonym_sets.SynonymSets, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), !isInitialLoading && synonymsData && synonymsData._meta.totalItemCount === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column",
    css: (0, _react2.css)({
      height: '75%'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    getStartedAction: () => {
      setIsCreateModalVisible(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  })))), embeddableConsole);
};
exports.SearchSynonymsOverview = SearchSynonymsOverview;