"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteEndpointModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_scan_usage = require("../../../../../../../hooks/use_scan_usage");
var _render_message_with_icon = require("../../component/render_message_with_icon");
var _scan_usage_results = require("../../component/scan_usage_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/all_inference_endpoints/render_table_columns/render_actions/actions/delete/confirm_delete_endpoint/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmDeleteEndpointModal = ({
  onCancel,
  onConfirm,
  inferenceEndpoint
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [isFetching, setIsFetching] = (0, _react.useState)(true);
  const [listOfUsages, setListOfUsages] = (0, _react.useState)([]);
  const [deleteDisabled, setDeleteDisabled] = (0, _react.useState)(true);
  const [ignoreWarningCheckbox, setIgnoreWarningCheckbox] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_scan_usage.useScanUsage)({
    type: inferenceEndpoint.task_type,
    id: inferenceEndpoint.inference_id
  });
  const onIgnoreWarningCheckboxChange = state => {
    setIgnoreWarningCheckbox(state);
    if (state) {
      setDeleteDisabled(false);
    } else {
      setDeleteDisabled(true);
    }
  };
  (0, _react.useEffect)(() => {
    if (!data) return;
    setIsFetching(false);
    const indices = data.indexes.map((index, id) => ({
      id: index,
      type: 'Index'
    }));
    const pipelines = data.pipelines.map((pipeline, id) => ({
      id: pipeline,
      type: 'Pipeline'
    }));
    const usages = [...indices, ...pipelines];
    if (usages.length > 0) {
      setDeleteDisabled(true);
    } else {
      setDeleteDisabled(false);
    }
    setListOfUsages(usages);
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    buttonColor: "danger",
    cancelButtonText: i18n.CANCEL,
    confirmButtonText: i18n.DELETE_ACTION_LABEL,
    defaultFocusedButton: "confirm",
    onCancel: onCancel,
    onConfirm: onConfirm,
    title: i18n.DELETE_TITLE,
    confirmButtonDisabled: deleteDisabled,
    "data-test-subj": "deleteModalForInferenceUI",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, i18n.CONFIRM_DELETE_WARNING), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
              font-family: ${_uiTheme.euiThemeVars.euiCodeFontFamily};
              font-weight: ${_uiTheme.euiThemeVars.euiCodeFontWeightBold};
            `,
    "data-test-subj": "deleteModalInferenceEndpointName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, inferenceEndpoint.inference_id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, isFetching ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "scanningUsageText",
    size: "xs",
    onClick: () => {},
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, i18n.SCANNING_USAGE_LABEL, "\u2026") : listOfUsages.length === 0 ? /*#__PURE__*/_react.default.createElement(_render_message_with_icon.RenderMessageWithIcon, {
    icon: "checkInCircleFilled",
    color: "success",
    label: i18n.NO_USAGE_FOUND_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_scan_usage_results.ScanUsageResults, {
    list: listOfUsages,
    ignoreWarningCheckbox: ignoreWarningCheckbox,
    onIgnoreWarningCheckboxChange: onIgnoreWarningCheckboxChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }))));
};
exports.ConfirmDeleteEndpointModal = ConfirmDeleteEndpointModal;