"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultCodingLanguage = getDefaultCodingLanguage;
var _code_examples = require("../code_examples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultCodingLanguage() {
  var _readConsoleDefaultLa;
  const defaultLang = (_readConsoleDefaultLa = readConsoleDefaultLanguage()) !== null && _readConsoleDefaultLa !== void 0 ? _readConsoleDefaultLa : 'python';
  return defaultLang;
}
const validLanguages = Object.keys(_code_examples.Languages);
const CONSOLE_DEFAULT_LANGUAGE_KEY = 'sense:defaultLanguage';
function readConsoleDefaultLanguage() {
  var _localStorage$getItem;
  const consoleLanguageValue = (_localStorage$getItem = localStorage.getItem(CONSOLE_DEFAULT_LANGUAGE_KEY)) === null || _localStorage$getItem === void 0 ? void 0 : _localStorage$getItem.replaceAll('"', ''); // Console is storing the value wrapped in "", so we want to remove them
  if (consoleLanguageValue && validLanguages.includes(consoleLanguageValue)) {
    return consoleLanguageValue;
  }
  return undefined;
}