"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateIndex = void 0;
var _react = require("react");
var _use_create_index = require("../../../hooks/api/use_create_index");
var _use_kibana = require("../../../hooks/use_kibana");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateIndex = workflow => {
  const {
    application,
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    createIndex,
    isSuccess,
    isLoading,
    data: createIndexResponse
  } = (0, _use_create_index.useCreateIndex)();
  (0, _react.useEffect)(() => {
    if (isSuccess && createIndexResponse !== undefined) {
      let query = '';
      if (workflow) {
        query = `?workflow=${encodeURIComponent(workflow)}`;
      }
      (0, _utils.navigateToIndexDetails)(application, http, createIndexResponse.index, query);
      return;
    }
  }, [application, http, isSuccess, createIndexResponse, workflow]);
  return {
    createIndex,
    isLoading
  };
};
exports.useCreateIndex = useCreateIndex;