"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerStatusRoutes = registerStatusRoutes;
var _configSchema = require("@kbn/config-schema");
var _routes = require("../../common/routes");
var _status = require("../lib/status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerStatusRoutes(router, logger) {
  router.get({
    path: _routes.GET_STATUS_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {},
    options: {
      access: 'internal'
    }
  }, async (context, _request, response) => {
    const core = await context.core;
    const client = core.elasticsearch.client.asCurrentUser;
    const body = await (0, _status.fetchIndicesStatus)(client, logger);
    return response.ok({
      body,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
  router.get({
    path: _routes.GET_USER_PRIVILEGES_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      })
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const core = await context.core;
    const client = core.elasticsearch.client.asCurrentUser;
    const {
      indexName
    } = request.params;
    const body = await (0, _status.fetchUserStartPrivileges)(client, logger, indexName);
    return response.ok({
      body,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}