"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSizeStats = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSizeStats = async (client, isServerless) => {
  if (isServerless) {
    // This API is only available on Serverless.
    const {
      _total: {
        size_in_bytes: sizeInBytes,
        num_docs: numDocs
      }
    } = await client.asSecondaryAuthUser.transport.request({
      method: 'GET',
      path: '/_metering/stats'
    });
    return {
      sizeStats: {
        size: new _configSchema.ByteSizeValue(sizeInBytes).toString(),
        documents: numDocs
      }
    };
  } else {
    var _stats$total$store$si, _stats$total, _stats$total$store, _stats$primaries$docs, _stats$primaries, _stats$primaries$docs2;
    // Hosted/Self managed
    const {
      _all: stats
    } = await client.asCurrentUser.indices.stats({
      expand_wildcards: ['hidden', 'all'],
      forbid_closed_indices: false,
      metric: ['docs', 'store']
    });
    return {
      sizeStats: {
        size: new _configSchema.ByteSizeValue((_stats$total$store$si = (_stats$total = stats.total) === null || _stats$total === void 0 ? void 0 : (_stats$total$store = _stats$total.store) === null || _stats$total$store === void 0 ? void 0 : _stats$total$store.size_in_bytes) !== null && _stats$total$store$si !== void 0 ? _stats$total$store$si : 0).toString(),
        documents: (_stats$primaries$docs = stats === null || stats === void 0 ? void 0 : (_stats$primaries = stats.primaries) === null || _stats$primaries === void 0 ? void 0 : (_stats$primaries$docs2 = _stats$primaries.docs) === null || _stats$primaries$docs2 === void 0 ? void 0 : _stats$primaries$docs2.count) !== null && _stats$primaries$docs !== void 0 ? _stats$primaries$docs : 0
      }
    };
  }
};
exports.fetchSizeStats = fetchSizeStats;