"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesStats = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_BASE_PATH = '/api/index_management';
const useIndicesStats = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryResult = (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndicesStats'],
    queryFn: async () => {
      const response = await http.get(`${API_BASE_PATH}/indices`);
      return response;
    },
    select: indices => {
      const hiddenIndices = indices.filter(index => index.hidden).length;
      const normalIndices = indices.filter(index => !index.hidden).length;
      const totalIndices = indices.length;
      return {
        totalIndices,
        hiddenIndices,
        normalIndices
      };
    }
  });
  return {
    ...queryResult
  };
};
exports.useIndicesStats = useIndicesStats;