"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_get_license_info = require("../../hooks/use_get_license_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/license_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LicenseBadge = () => {
  const {
    isTrial,
    licenseType
  } = (0, _use_get_license_info.useGetLicenseInfo)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const LICENSE_LABEL = {
    trial: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.trial', {
      defaultMessage: 'TRIAL'
    }),
    basic: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.basic', {
      defaultMessage: 'BASIC'
    }),
    standard: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.standard', {
      defaultMessage: 'STANDARD'
    }),
    gold: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.gold', {
      defaultMessage: 'GOLD'
    }),
    platinum: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.platinum', {
      defaultMessage: 'PLATINUM'
    }),
    enterprise: _i18n.i18n.translate('xpack.searchHomepage.licenseLabel.enterprise', {
      defaultMessage: 'ENTERPRISE'
    })
  };
  return licenseType && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: (0, _react2.css)({
      borderRadius: euiTheme.size.l,
      padding: `0 ${euiTheme.size.m}`
    }),
    color: isTrial ? 'primary' : 'hollow',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, LICENSE_LABEL[licenseType]);
};
exports.LicenseBadge = LicenseBadge;