"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudResources = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _doc_links = require("../../../common/doc_links");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/cloud_resources.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResourceCard = ({
  title,
  icon,
  description,
  actionHref,
  actionText,
  dataTestSubj
}) => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    css: (0, _react2.css)({
      maxWidth: euiTheme.base * 36
    }),
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: (0, _react2.css)({
      backgroundColor: euiTheme.colors.backgroundBaseSubdued
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)({
      margin: `${euiTheme.size.xxl} 0`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: euiTheme.base * 5,
    src: icon(assetBasePath),
    alt: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    iconType: "sortRight",
    color: "text",
    "data-test-subj": "searchHomepageSearchCloudResourceCardAction",
    href: actionHref,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, actionText)))));
};
const CloudResources = () => {
  const {
    services: {
      cloud
    }
  } = (0, _use_kibana.useKibana)();
  const isServerless = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled;
  const [billingUrl, setBillingUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    cloud === null || cloud === void 0 ? void 0 : cloud.getPrivilegedUrls().then(urls => {
      if (urls.billingUrl) {
        setBillingUrl(urls.billingUrl);
      }
    });
  }, [cloud]);
  const SERVERLESS_CARDS = [{
    icon: assetBasePath => `${assetBasePath}/search_value_calc.svg`,
    title: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.billing.title', {
      defaultMessage: 'Cloud Billing and Usage'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.billing.description', {
      defaultMessage: 'Get a detailed breakdown of your organization’s cloud resource usage across your deployments.'
    }),
    actionText: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.billing.actionText', {
      defaultMessage: 'Go to Billing'
    }),
    actionHref: billingUrl,
    dataTestSubj: 'cloudResourceCard-billing'
  }, {
    icon: assetBasePath => `${assetBasePath}/search_analytics.svg`,
    title: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.autoops.title', {
      defaultMessage: 'Cluster performance insights'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.autoops.description', {
      defaultMessage: 'Enable AutoOps for performance recommendations, resource utilization, and cost insights.'
    }),
    actionText: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.autoops.actionText', {
      defaultMessage: 'AutoOps'
    }),
    actionHref: (cloud === null || cloud === void 0 ? void 0 : cloud.performanceUrl) || `https://cloud.elastic.co`,
    dataTestSubj: 'cloudResourceCard-autoops'
  }];
  const HOSTED_CARDS = [{
    icon: assetBasePath => `${assetBasePath}/search_cloud_deploy.svg`,
    title: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.cloudConnect.title', {
      defaultMessage: 'Cloud Connect'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.cloudConnect.description', {
      defaultMessage: 'Use Elastic Cloud services like AutoOps and Elastic Inference Service in your self-managed clusters.'
    }),
    actionText: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.cloudConnect.actionText', {
      defaultMessage: 'Connect this cluster'
    }),
    actionHref: _doc_links.docLinks.cloudConnect,
    dataTestSubj: 'cloudResourceCard-cloudConnect'
  }, {
    icon: assetBasePath => `${assetBasePath}/search_serverless.svg`,
    title: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.elasticCloud.title', {
      defaultMessage: 'Try manage Elastic'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.elasticCloud.description', {
      defaultMessage: 'Deploy, scale and upgrade your stack faster with Elastic Cloud. We’ll help you quickly move your data.'
    }),
    actionText: _i18n.i18n.translate('xpack.searchHomepage.cloudResources.elasticCloud.actionText', {
      defaultMessage: 'Elastic Cloud'
    }),
    actionHref: _doc_links.docLinks.elasticCloud,
    dataTestSubj: 'cloudResourceCard-serverless'
  }];
  const cards = isServerless ? SERVERLESS_CARDS : HOSTED_CARDS;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.cloudResources.h6.cloudResourcesLabel', {
    defaultMessage: 'Cloud resources'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, cards.map((card, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `resource-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(ResourceCard, {
    title: card.title,
    icon: card.icon,
    description: card.description,
    actionHref: card.actionHref,
    actionText: card.actionText,
    dataTestSubj: card.dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }))))));
};
exports.CloudResources = CloudResources;