"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicMetricBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_dashboards_stats = require("../../hooks/api/use_dashboards_stats");
var _use_indices_stats = require("../../hooks/api/use_indices_stats");
var _use_stats = require("../../hooks/api/use_stats");
var _use_agent_count = require("../../hooks/api/use_agent_count");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/basic_metric_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BASIC_METRIC_PANEL_TYPES = ['indices', 'storage', 'agentBuilder', 'discover'];
const BasicMetricPanel = ({
  title,
  metric,
  isLoading = false,
  isError = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: euiTheme.colors.backgroundBaseSubdued,
    css: (0, _react2.css)({
      padding: `${euiTheme.size.xs} ${euiTheme.size.m}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, title), "\xA0\xA0", isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 23
    }
  }), !isLoading && isError && '—', !isLoading && !isError && (Array.isArray(metric) ? metric.map(m => {
    var _ref;
    return (_ref = m && `${m} `) !== null && _ref !== void 0 ? _ref : null;
  }) : metric)));
};
const BasicMetricBadges = () => {
  var _indicesData$normalIn, _storageStats$size, _dashboardsData$total;
  const {
    data: storageStats,
    isLoading: isLoadingStorageStats,
    isError: isErrorStorageStats
  } = (0, _use_stats.useStats)();
  const {
    data: indicesData,
    isLoading: isLoadingIndices,
    isError: isErrorIndicesStats
  } = (0, _use_indices_stats.useIndicesStats)();
  const {
    data: dashboardsData,
    isLoading: isLoadingDashboards,
    isError: isErrorDashboards
  } = (0, _use_dashboards_stats.useDashboardsStats)();
  const {
    tools,
    agents,
    isLoading: isLoadingAgents,
    isError: isErrorAgents
  } = (0, _use_agent_count.useAgentCount)();
  const basicPanels = [{
    type: 'indices',
    title: _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.indices.title', {
      defaultMessage: 'Indices'
    }),
    metric: (_indicesData$normalIn = indicesData === null || indicesData === void 0 ? void 0 : indicesData.normalIndices) !== null && _indicesData$normalIn !== void 0 ? _indicesData$normalIn : 0,
    isLoading: isLoadingIndices,
    isError: isErrorIndicesStats
  }, {
    type: 'storage',
    title: _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.storage.title', {
      defaultMessage: 'Storage'
    }),
    metric: (_storageStats$size = storageStats === null || storageStats === void 0 ? void 0 : storageStats.size) !== null && _storageStats$size !== void 0 ? _storageStats$size : '-',
    isLoading: isLoadingStorageStats,
    isError: isErrorStorageStats
  }, {
    type: 'agentBuilder',
    title: _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.agentBuilder.title', {
      defaultMessage: 'Agent Builder'
    }),
    metric: [agents !== undefined && agents !== null ? _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.agentBuilder.agents', {
      defaultMessage: '{agents} agents',
      values: {
        agents
      }
    }) : undefined, tools !== undefined && tools !== null ? _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.agentBuilder.tools', {
      defaultMessage: '{tools} tools',
      values: {
        tools
      }
    }) : undefined],
    isLoading: isLoadingAgents,
    isError: isErrorAgents
  }, {
    type: 'discover',
    title: _i18n.i18n.translate('xpack.searchHomepage.metricPanel.basic.discover.title', {
      defaultMessage: 'Dashboards'
    }),
    metric: (_dashboardsData$total = dashboardsData === null || dashboardsData === void 0 ? void 0 : dashboardsData.totalDashboards) !== null && _dashboardsData$total !== void 0 ? _dashboardsData$total : 0,
    isLoading: isLoadingDashboards,
    isError: isErrorDashboards
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, basicPanels.map(panel => {
    return /*#__PURE__*/_react.default.createElement(BasicMetricPanel, {
      title: panel.title,
      metric: panel.metric,
      key: panel.type,
      isLoading: panel.isLoading,
      isError: panel.isError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    });
  }));
};
exports.BasicMetricBadges = BasicMetricBadges;