"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _i18n = require("@kbn/i18n");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/api_key_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const API_KEY_MASK = '•'.repeat(60);
// TODO: Instead of this component, use the shared ApiKeyForm from @kbn/search-api-keys-components
//   or remove after getting started page is complete.
const ApiKeyFormContent = ({
  apiKey,
  status,
  toggleApiKeyVisibility,
  updateApiKey,
  manageKeysLink
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  return apiKey ? /*#__PURE__*/_react.default.createElement(_searchSharedUi.FormInfoField, {
    value: status === _searchApiKeysComponents.Status.showPreviewKey ? apiKey : API_KEY_MASK,
    copyValue: apiKey,
    dataTestSubj: "searchHomepageApiKeyFormAPIKey",
    copyValueDataTestSubj: "searchHomepageAPIKeyButtonCopy",
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: status === _searchApiKeysComponents.Status.showPreviewKey ? 'eyeClosed' : 'eye',
      color: "text",
      display: "empty",
      onClick: toggleApiKeyVisibility,
      "data-test-subj": "searchHomepageShowAPIKeyButton",
      "aria-label": _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.showApiKey', {
        defaultMessage: 'Show API key'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: "gear",
      display: "empty",
      color: "text",
      href: manageKeysLink,
      target: "_blank",
      "aria-label": _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.manageApiKeys', {
        defaultMessage: 'Manage API keys'
      }),
      "data-test-subj": "manageApiKeysButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    size: "s",
    iconSide: "left",
    iconType: "key",
    onClick: () => setShowFlyout(true),
    "data-test-subj": "createApiKeyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.apiKeyForm.createButton",
    defaultMessage: "Create API key",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_searchApiKeysComponents.ApiKeyFlyoutWrapper, {
    onCancel: () => setShowFlyout(false),
    onSuccess: ({
      id,
      encoded
    }) => {
      updateApiKey({
        id,
        encoded
      });
      setShowFlyout(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  })));
};
const ApiKeysUserPrivilegesError = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  justifyContent: "flexStart",
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  "data-test-subj": "apiKeyFormNoUserPrivileges",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 7
  }
}, _i18n.i18n.translate('xpack.searchHomepage.apiKeyForm.noUserPrivileges', {
  defaultMessage: 'Contact an administrator to manage API keys'
}))));
const ApiKeyForm = () => {
  var _share$url;
  const {
    apiKey,
    status,
    updateApiKey,
    toggleApiKeyVisibility
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  const locator = share === null || share === void 0 ? void 0 : (_share$url = share.url) === null || _share$url === void 0 ? void 0 : _share$url.locators.get('MANAGEMENT_APP_LOCATOR');
  const manageKeysLink = locator === null || locator === void 0 ? void 0 : locator.useUrl({
    sectionId: 'security',
    appId: 'api_keys'
  });
  const queryClient = (0, _reactQuery.useQueryClient)();
  (0, _react.useEffect)(() => {
    queryClient.invalidateQueries([_constants.QueryKeys.ApiKey]);
  }, [apiKey, queryClient]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, status === _searchApiKeysComponents.Status.showUserPrivilegesError ? /*#__PURE__*/_react.default.createElement(ApiKeysUserPrivilegesError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(ApiKeyFormContent, {
    apiKey: apiKey,
    status: status,
    updateApiKey: updateApiKey,
    toggleApiKeyVisibility: toggleApiKeyVisibility,
    manageKeysLink: manageKeysLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })));
};
exports.ApiKeyForm = ApiKeyForm;