"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleTutorialsGroup = void 0;
var _searchCodeExamples = require("@kbn/search-code-examples");
var _tryInConsole = require("@kbn/try-in-console");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _section_heading = require("../section_heading");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_getting_started/public/components/tutorials/console_tutorials_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConsoleTutorialsGroup = () => {
  const {
    application,
    console: consolePlugin,
    share
  } = (0, _use_kibana.useKibana)().services;
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const tutorials = (0, _react.useMemo)(() => [{
    title: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.basicsTitle', {
      defaultMessage: 'Search basics'
    }),
    dataTestSubj: 'console_tutorials_search_basics',
    description: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.basicsDescription', {
      defaultMessage: 'Learn how to create an index, add documents, and basic search techniques.'
    }),
    request: _searchCodeExamples.consoleTutorials.basics,
    image: `${assetBasePath}/search_window_illustration.svg`,
    buttonRef: /*#__PURE__*/_react.default.createRef()
  }, {
    title: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.semanticTitle', {
      defaultMessage: 'Intro to semantic search'
    }),
    dataTestSubj: 'console_tutorials_semantic_search',
    description: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.semanticDescription', {
      defaultMessage: 'Learn semantic search techniques to understand intent and deliver more accurate, relevant results.'
    }),
    request: _searchCodeExamples.consoleTutorials.semanticSearch,
    image: `${assetBasePath}/search_results_illustration.svg`,
    buttonRef: /*#__PURE__*/_react.default.createRef()
  }, {
    title: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.esqlTitle', {
      defaultMessage: 'ES|QL fundamentals'
    }),
    dataTestSubj: 'console_tutorials_esql',
    description: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.esqlDescription', {
      defaultMessage: "Learn how to use Elastic's piped query language to simplify data investigations."
    }),
    request: _searchCodeExamples.consoleTutorials.esql,
    image: `${assetBasePath}/search_observe_illustration.svg`,
    buttonRef: /*#__PURE__*/_react.default.createRef()
  }
  // TODO:  uncomment below lines when we are ready to show TSDS tutorial. review https://github.com/elastic/kibana/pull/237384#issuecomment-3411670210
  // {
  //   title: i18n.translate('xpack.searchGettingStarted.consoleTutorials.tsdsTitle', {
  //     defaultMessage: 'Time series data streams',
  //   }),
  //   dataTestSubj: 'console_tutorials_tsds',
  //   description: i18n.translate('xpack.searchHomepage.consoleTutorials.tsdsDescription', {
  //     defaultMessage:
  //       'Learn how to use a time series data stream (TSDS) to store timestamped metrics data.',
  //   }),
  //   request: consoleTutorials.timeSeriesDataStreams,
  //   image: null,
  //   buttonRef: useRef<HTMLButtonElement>(null),
  // },
  ], [assetBasePath]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: 'column',
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_section_heading.SearchGettingStartedSectionHeading, {
    title: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.label', {
      defaultMessage: 'Explore the API'
    }),
    icon: `${assetBasePath}/command_line.svg`,
    description: _i18n.i18n.translate('xpack.searchGettingStarted.consoleTutorials.description', {
      defaultMessage: 'Choose a tutorial and use Console to quickly start interacting with the Elasticsearch API.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, tutorials.map(tutorial => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: tutorial.dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    title: tutorial.title,
    titleSize: "xs",
    textAlign: "left",
    onClick: () => {
      var _tutorial$buttonRef$c;
      (_tutorial$buttonRef$c = tutorial.buttonRef.current) === null || _tutorial$buttonRef$c === void 0 ? void 0 : _tutorial$buttonRef$c.click();
    },
    "data-test-subj": tutorial.dataTestSubj,
    footer: /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
      type: "button",
      iconType: `${assetBasePath}/command_line.svg` // TODO: Replace with EUI icon when it's available
      ,
      color: "text",
      request: tutorial.request,
      application: application,
      sharePlugin: share,
      consolePlugin: consolePlugin,
      telemetryId: tutorial.dataTestSubj,
      "data-test-subj": `${tutorial.dataTestSubj}-btn`,
      buttonProps: {
        buttonRef: tutorial.buttonRef
      },
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchGettingStarted.consoleTutorials.runInConsole",
        defaultMessage: "Open in Console",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 23
        }
      }),
      onClick: e => {
        // Do not trigger the card click
        e.stopPropagation();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    justifyContent: "center",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 25
    }
  }, tutorial.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: tutorial.image,
    alt: `${tutorial.title} tutorial icon`,
    size: "original",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 21
    }
  })))))))));
};
exports.ConsoleTutorialsGroup = ConsoleTutorialsGroup;