"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilteringRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filtering_rule_helpers = require("../../utils/filtering_rule_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/sync_jobs/filtering_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FilteringRulesTable = ({
  showOrder,
  filteringRules
}) => {
  const columns = [...(showOrder ? [{
    field: 'order',
    name: _i18n.i18n.translate('searchConnectors.index.filtering.priority', {
      defaultMessage: 'Rule priority'
    })
  }] : []), {
    field: 'policy',
    name: _i18n.i18n.translate('searchConnectors.index.filtering.policy', {
      defaultMessage: 'Policy'
    }),
    render: policy => (0, _filtering_rule_helpers.filteringPolicyToText)(policy)
  }, {
    field: 'field',
    name: _i18n.i18n.translate('searchConnectors.index.filtering.field', {
      defaultMessage: 'field'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 34
      }
    }, value)
  }, {
    field: 'rule',
    name: _i18n.i18n.translate('searchConnectors.index.filtering.rule', {
      defaultMessage: 'Rule'
    }),
    render: rule => (0, _filtering_rule_helpers.filteringRuleToText)(rule)
  }, {
    field: 'value',
    name: _i18n.i18n.translate('searchConnectors.index.filtering.value', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 34
      }
    }, value)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('searchConnectors.index.filteringRulesTable.tableCaption', {
      defaultMessage: 'Filtering rules'
    }),
    columns: columns,
    items: filteringRules.sort(({
      order
    }, {
      order: secondOrder
    }) => order - secondOrder),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
};
exports.FilteringRulesTable = FilteringRulesTable;