"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromiumArchivePaths = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var BaseUrl = /*#__PURE__*/function (BaseUrl) {
  BaseUrl["custom"] = "https://storage.googleapis.com/headless_shell";
  BaseUrl["chromeForTesting"] = "https://storage.googleapis.com/chrome-for-testing-public";
  return BaseUrl;
}(BaseUrl || {});
function isChromeForTestingPackage(p) {
  return p.location === 'chromeForTesting';
}
class ChromiumArchivePaths {
  constructor() {
    (0, _defineProperty2.default)(this, "packages", [{
      platform: 'darwin',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-mac-x64.zip',
      archiveChecksum: 'ed68e639d6b3791efef347d5eca4c3f824d3092f423fa27f2240ffc85d40a456',
      binaryChecksum: '4eaec5719503b65ab00b17755b2a8db5570ff76f44824e50615e901e5d437bfd',
      binaryRelativePath: 'chrome-headless-shell-mac-x64/chrome-headless-shell',
      version: '143.0.7499.40',
      location: 'chromeForTesting',
      archivePath: 'mac-x64',
      isPreInstalled: false
    }, {
      platform: 'darwin',
      architecture: 'arm64',
      archiveFilename: 'chrome-headless-shell-mac-arm64.zip',
      archiveChecksum: 'ac928a69b720d75c7fcf18a1f1dfde2ce37e4c525ba48d8810ef4c51391fd945',
      binaryChecksum: '567dbbd3fd50ff9f1e6186f839711bf6986ff50fb36af0f80ca58217d42e385e',
      binaryRelativePath: 'chrome-headless-shell-mac-arm64/chrome-headless-shell',
      version: '143.0.7499.40',
      location: 'chromeForTesting',
      archivePath: 'mac-arm64',
      isPreInstalled: false
    }, {
      platform: 'linux',
      architecture: 'x64',
      archiveFilename: 'chromium-c23ff45-locales-linux_x64.zip',
      archiveChecksum: '8b07f71eea31e80821819e67c99a6fb58417960886a73fe6ae05190bc15bab85',
      binaryChecksum: 'ac04bf80e70ff0ea431c7da4f471156343b850fca66a28488eb5b6b2703ed96b',
      binaryRelativePath: 'headless_shell-linux_x64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'linux',
      architecture: 'arm64',
      archiveFilename: 'chromium-c23ff45-locales-linux_arm64.zip',
      archiveChecksum: 'f15fd107c568c2efeec9b9bb1ca5d29d70ebe492407ed5df998d0247f96bdabe',
      binaryChecksum: '4f2943e46128e9af370184ef592b352c7046995564cfbebf55a845c40def8bdb',
      binaryRelativePath: 'headless_shell-linux_arm64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'win32',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-win64.zip',
      archiveChecksum: '67e48f40c732bff9a7b3e4aec9886e61f8b75b4fee83ac7e179d3344909696e0',
      binaryChecksum: 'e2080d7b9a2ab39fec90f5f65bdaf546c834dd086d90dd0d9a0400ec77596a8f',
      binaryRelativePath: _path.default.join('chrome-headless-shell-win64', 'chrome-headless-shell.exe'),
      version: '143.0.7499.40',
      location: 'chromeForTesting',
      archivePath: 'win64',
      isPreInstalled: true
    }]);
    // zip files get downloaded to a .chromium directory in the kibana root
    (0, _defineProperty2.default)(this, "archivesPath", _path.default.resolve(__dirname, '../../../../../../.chromium'));
  }
  find(platform, architecture, packages = this.packages) {
    return packages.find(p => p.platform === platform && p.architecture === architecture);
  }
  resolvePath(p) {
    // adding architecture to the path allows it to download two binaries that have the same name, but are different architecture
    return _path.default.resolve(this.archivesPath, p.architecture, p.archiveFilename);
  }
  getAllArchiveFilenames() {
    return this.packages.map(p => this.resolvePath(p));
  }
  getDownloadUrl(p) {
    if (isChromeForTestingPackage(p)) {
      const {
        chromeForTesting
      } = BaseUrl;
      const {
        archivePath,
        version,
        archiveFilename
      } = p;
      // returned string matches download value found at the following endpoint;
      // https://googlechromelabs.github.io/chrome-for-testing/known-good-versions-with-downloads.json
      return `${chromeForTesting}/${version}/${archivePath}/${archiveFilename}`;
    }
    return BaseUrl.custom + '/' + p.archiveFilename; // revision is not used for URL if package is a custom build
  }
  getBinaryPath(p, chromiumPath) {
    return _path.default.join(chromiumPath, p.binaryRelativePath);
  }
}
exports.ChromiumArchivePaths = ChromiumArchivePaths;