"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isServerValidationError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Error returned from the server when attributes validation fails for `create` or `update` operations
 */

const isServerValidationError = error => {
  var _error$attributes;
  return error && error.statusCode === 400 && typeof ((_error$attributes = error.attributes) === null || _error$attributes === void 0 ? void 0 : _error$attributes.valid) === 'boolean' && typeof error.attributes.errors === 'object';
};
exports.isServerValidationError = isServerValidationError;