"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeRequiredChanges = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Compute the list of objects that need to be added or removed from the
 * tag assignation, given their initial status and their current manual override.
 */
const computeRequiredChanges = ({
  objects,
  initialStatus,
  overrides
}) => {
  const assigned = [];
  const unassigned = [];
  objects.forEach(object => {
    const key = (0, _utils.getKey)(object);
    const status = initialStatus[key];
    const override = overrides[key];
    const action = (0, _utils.getAssignmentAction)(status, override);
    if (action === 'added') {
      assigned.push(object);
    }
    if (action === 'removed') {
      unassigned.push(object);
    }
  });
  return {
    assigned,
    unassigned
  };
};
exports.computeRequiredChanges = computeRequiredChanges;